/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.ConfigurationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;

public class ConfigurationFactory<T> {
    private final Class<T> clazz;
    private final ObjectMapper objectMapper;
    private final Validator validator;
    private final JsonFactory parserFactory;
    private static final String DEFAULT_SDK_CONFIG_FILE = "phonepe_java_sdk_properties.yml";

    public ConfigurationFactory(Class<T> clazz) {
        this.clazz = clazz;
        this.parserFactory = new YAMLFactory();
        this.validator = Validation.buildDefaultValidatorFactory().getValidator();
        this.objectMapper = new ObjectMapper();
        this.objectMapper.findAndRegisterModules();
        this.objectMapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public T build() throws IOException, ConfigurationException {
        return this.build(DEFAULT_SDK_CONFIG_FILE);
    }

    public T build(String fileName) throws IOException, ConfigurationException {
        Preconditions.checkNotNull((Object)fileName);
        File file = null;
        try {
            file = new File(fileName);
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fileName);
            JsonNode node = (JsonNode)this.objectMapper.readTree(this.createParser(inputStream));
            String filename = file.toString();
            return this.build(node, filename);
        }
        catch (JsonParseException exception) {
            throw new ConfigurationException(file.toString(), exception.getMessage());
        }
    }

    protected JsonParser createParser(InputStream inputStream) throws IOException {
        return this.parserFactory.createParser(inputStream);
    }

    private T build(JsonNode node, String filename) throws IOException, ConfigurationException {
        Object config = this.objectMapper.readValue((JsonParser)new TreeTraversingParser(node), this.clazz);
        this.validate(filename, config);
        return (T)config;
    }

    private void validate(String file, T config) throws ConfigurationException {
        Set violations;
        if (this.validator != null && !(violations = this.validator.validate(config, new Class[0])).isEmpty()) {
            throw new ConfigurationException(file, violations);
        }
    }

    public static <T> ConfigurationFactoryBuilder<T> builder() {
        return new ConfigurationFactoryBuilder();
    }

    public static class ConfigurationFactoryBuilder<T> {
        private Class<T> clazz;

        ConfigurationFactoryBuilder() {
        }

        public ConfigurationFactoryBuilder<T> clazz(Class<T> clazz) {
            this.clazz = clazz;
            return this;
        }

        public ConfigurationFactory<T> build() {
            return new ConfigurationFactory<T>(this.clazz);
        }

        public String toString() {
            return "ConfigurationFactory.ConfigurationFactoryBuilder(clazz=" + this.clazz + ")";
        }
    }
}

