/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init;

import com.phonepe.sdk.javasdk.transaction.init.TransactionInitComponent;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitDecorator;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.models.MerchantContext;
import com.phonepe.sdk.javasdk.transaction.init.models.OfferContext;
import com.phonepe.sdk.javasdk.transaction.init.models.OfferTag;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfferTransactionComponent
extends TransactionInitDecorator {
    private static final Logger log = LoggerFactory.getLogger(OfferTransactionComponent.class);
    private Set<String> offerTagIds;

    public OfferTransactionComponent(TransactionInitComponent transactionInitComponent, Set<String> offerTagIds) {
        super(transactionInitComponent);
        this.offerTagIds = offerTagIds;
    }

    @Override
    public InitRequest getInitRequest(String merchantId, String transactionId, Long amount) {
        InitRequest initRequest = this.transactionInitComponent.getInitRequest(merchantId, transactionId, amount);
        Set<OfferTag> offerTagSet = this.getOfferTags(amount);
        OfferContext offerContext = OfferContext.builder().tags(offerTagSet).build();
        MerchantContext merchantContext = initRequest.getMerchantContext();
        if (merchantContext != null) {
            merchantContext.setOfferContext(offerContext);
        } else {
            merchantContext = MerchantContext.builder().offerContext(offerContext).build();
        }
        initRequest.setMerchantContext(merchantContext);
        return initRequest;
    }

    private Set<OfferTag> getOfferTags(Long amount) {
        HashSet<OfferTag> offerTags = new HashSet<OfferTag>();
        for (String tagId : this.offerTagIds) {
            offerTags.add(OfferTag.builder().id(tagId).amount(amount).build());
        }
        return offerTags;
    }

    public static OfferTransactionComponentBuilder builder() {
        return new OfferTransactionComponentBuilder();
    }

    public static class OfferTransactionComponentBuilder {
        private TransactionInitComponent transactionInitComponent;
        private Set<String> offerTagIds;

        OfferTransactionComponentBuilder() {
        }

        public OfferTransactionComponentBuilder transactionInitComponent(TransactionInitComponent transactionInitComponent) {
            this.transactionInitComponent = transactionInitComponent;
            return this;
        }

        public OfferTransactionComponentBuilder offerTagIds(Set<String> offerTagIds) {
            this.offerTagIds = offerTagIds;
            return this;
        }

        public OfferTransactionComponent build() {
            return new OfferTransactionComponent(this.transactionInitComponent, this.offerTagIds);
        }

        public String toString() {
            return "OfferTransactionComponent.OfferTransactionComponentBuilder(transactionInitComponent=" + this.transactionInitComponent + ", offerTagIds=" + this.offerTagIds + ")";
        }
    }
}

