package com.phonepe.sdk.javasdk.config.models;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Max;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class Metrics {
    @Max(60000L)
    private int statsTimeInMillis = 60000;

    @Builder.Default
    private int healthCheckInterval = 500;

    @Builder.Default
    private int percentileTimeInMillis = 60000;

    @Builder.Default
    private int percentileBucketSize = 100;

    @Builder.Default
    private int numBucketSize = 100;
}
