/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init.web;

import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebTransactionInitiator
extends TransactionInitiator {
    private static final Logger log = LoggerFactory.getLogger(WebTransactionInitiator.class);

    public WebTransactionInitiator(TransactionClient transactionClient, InitConfig initConfig, MerchantConfig merchantConfig) {
        super(transactionClient, initConfig, merchantConfig);
    }

    @Override
    protected InitRequest buildInitRequest(String merchantId, String transactionId, String userId, Long amount, String orderId) {
        return InitRequest.builder().merchantId(merchantId).transactionId(transactionId).merchantOrderId(orderId).merchantUserId(userId).amount(amount).build();
    }

    public static WebTransactionInitiatorBuilder builder() {
        return new WebTransactionInitiatorBuilder();
    }

    public static class WebTransactionInitiatorBuilder {
        private TransactionClient transactionClient;
        private InitConfig initConfig;
        private MerchantConfig merchantConfig;

        WebTransactionInitiatorBuilder() {
        }

        public WebTransactionInitiatorBuilder transactionClient(TransactionClient transactionClient) {
            this.transactionClient = transactionClient;
            return this;
        }

        public WebTransactionInitiatorBuilder initConfig(InitConfig initConfig) {
            this.initConfig = initConfig;
            return this;
        }

        public WebTransactionInitiatorBuilder merchantConfig(MerchantConfig merchantConfig) {
            this.merchantConfig = merchantConfig;
            return this;
        }

        public WebTransactionInitiator build() {
            return new WebTransactionInitiator(this.transactionClient, this.initConfig, this.merchantConfig);
        }

        public String toString() {
            return "WebTransactionInitiator.WebTransactionInitiatorBuilder(transactionClient=" + this.transactionClient + ", initConfig=" + this.initConfig + ", merchantConfig=" + this.merchantConfig + ")";
        }
    }
}

