package com.phonepe.sdk.javasdk.transaction.init.models;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.annotation.Nonnegative;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OfferTag {

    @NotBlank
    private String id;

    @Min(1)
    @Nonnegative
    private Long amount;

    @Builder.Default
    private String denomination = "PAISE";
}
