/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.HttpClientConfig;
import com.phonepe.sdk.javasdk.config.models.HystrixConfig;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.PhonePeSDKConfig;
import com.phonepe.sdk.javasdk.config.models.StatusConfig;
import com.phonepe.sdk.javasdk.http.PhonePeHttpClientFactory;
import com.phonepe.sdk.javasdk.transaction.callback.CallbackHandler;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.init.models.AllowedAccountConstraint;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.init.web.WebTransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.status.TransactionStatusChecker;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import java.util.List;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhonePeClient {
    private static final Logger log = LoggerFactory.getLogger(PhonePeClient.class);
    private TransactionInitiator transactionInitiator;
    private CallbackHandler callbackHandler;
    private TransactionStatusChecker statusChecker;

    public PhonePeClient(PhonePeSDKConfig phonePeSDKConfig) {
        Preconditions.checkNotNull((Object)phonePeSDKConfig);
        this.init(phonePeSDKConfig);
    }

    public void init(PhonePeSDKConfig phonePeSDKConfig) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
            HttpClientConfig httpClientConfig = phonePeSDKConfig.getHttpClientConfig();
            StatusConfig statusConfig = phonePeSDKConfig.getStatusConfig();
            MerchantConfig merchantConfig = phonePeSDKConfig.getMerchantConfig();
            InitConfig initConfig = phonePeSDKConfig.getInitConfig();
            HystrixConfig hystrixConfig = phonePeSDKConfig.getHystrixConfig();
            OkHttpClient client = PhonePeHttpClientFactory.buildOkHttpClient(httpClientConfig);
            TransactionClient transactionClient = new TransactionClient(httpClientConfig, objectMapper, client, hystrixConfig);
            this.statusChecker = TransactionStatusChecker.builder().merchantConfig(merchantConfig).statusConfig(statusConfig).transactionClient(transactionClient).build();
            this.callbackHandler = CallbackHandler.builder().merchantConfig(merchantConfig).transactionStatusChecker(this.statusChecker).build();
            this.transactionInitiator = WebTransactionInitiator.builder().initConfig(initConfig).merchantConfig(merchantConfig).transactionClient(transactionClient).build();
        }
        catch (Exception ex) {
            log.error("Exception occurred during PhonePeClient init");
        }
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount) {
        return this.transactionInitiator.initiateTransaction(transactionId, amount);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount, Set<String> offerTags) {
        return this.transactionInitiator.initiateTransaction(transactionId, amount, userId, offerTags);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount, List<AllowedAccountConstraint> allowedAccountConstraints) {
        return this.transactionInitiator.initiateTransaction(transactionId, amount, userId, allowedAccountConstraints);
    }

    public StatusResponse handleCallback(String responseReceived, String checksum) {
        return this.callbackHandler.handleCallback(responseReceived, checksum);
    }

    public StatusResponse checkTransactionStatus(String transactionId) {
        return this.statusChecker.checkTransactionStatus(transactionId);
    }

    public static PhonePeClientBuilder builder() {
        return new PhonePeClientBuilder();
    }

    public static class PhonePeClientBuilder {
        private PhonePeSDKConfig phonePeSDKConfig;

        PhonePeClientBuilder() {
        }

        public PhonePeClientBuilder phonePeSDKConfig(PhonePeSDKConfig phonePeSDKConfig) {
            this.phonePeSDKConfig = phonePeSDKConfig;
            return this;
        }

        public PhonePeClient build() {
            return new PhonePeClient(this.phonePeSDKConfig);
        }

        public String toString() {
            return "PhonePeClient.PhonePeClientBuilder(phonePeSDKConfig=" + this.phonePeSDKConfig + ")";
        }
    }
}

