/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init;

import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitComponent;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTransactionComponent
implements TransactionInitComponent {
    private static final Logger log = LoggerFactory.getLogger(SimpleTransactionComponent.class);

    public InitRequest getInitRequest(String merchantId, String transactionId, Long amount) {
        Preconditions.checkNotNull((Object)merchantId);
        Preconditions.checkNotNull((Object)transactionId);
        Preconditions.checkNotNull((Object)amount);
        return this.getInitRequest(merchantId, transactionId, "", amount);
    }

    @Override
    public InitRequest getInitRequest(String merchantId, String userId, String transactionId, Long amount) {
        return this.getInitRequest(merchantId, transactionId, userId, amount, transactionId);
    }

    public InitRequest getInitRequest(String merchantId, String transactionId, String userId, Long amount, String orderId) {
        String message = this.getGenericMessage(orderId);
        return this.getInitRequest(merchantId, transactionId, userId, amount, orderId, message);
    }

    public InitRequest getInitRequest(String merchantId, String transactionId, String userId, Long amount, String orderId, String message) {
        return this.buildInitRequest(merchantId, transactionId, userId, amount, orderId, message);
    }

    private InitRequest buildInitRequest(String merchantId, String transactionId, String userId, Long amount, String orderId, String message) {
        return InitRequest.builder().merchantId(merchantId).transactionId(transactionId).merchantOrderId(orderId).merchantUserId(userId).amount(amount).message(message).build();
    }

    private String getGenericMessage(String orderId) {
        return String.format("Payment for orderId: %s", orderId);
    }
}

