package com.phonepe.sdk.javasdk.transaction.init;

import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class SimpleTransactionComponent implements TransactionInitComponent {


    @Override
    public InitRequest getInitRequest(final String merchantId,
                                      final String transactionId,
                                      final Long amount) {
        Preconditions.checkNotNull(merchantId);
        Preconditions.checkNotNull(transactionId);
        Preconditions.checkNotNull(amount);
        return getInitRequest(merchantId, transactionId, "",amount);

    }

    public InitRequest getInitRequest(final String merchantId,
                                      final String transactionId,
                                      final String userId,
                                      final Long amount){
        return getInitRequest(merchantId,transactionId,userId,amount,transactionId);
    }

    public InitRequest getInitRequest(final String merchantId,
                                      final String transactionId,
                                      final String userId,
                                      final Long amount,
                                      final String orderId){


        final String message = getGenericMessage(orderId);
        return getInitRequest(merchantId,
                              transactionId,
                              userId,
                              amount,
                              orderId,
                              message);
    }

    public InitRequest getInitRequest(final String merchantId,
                                      final String transactionId,
                                      final String userId,
                                      final Long amount,
                                      final String orderId,
                                      final String message){
        return buildInitRequest(merchantId,transactionId, userId, amount, orderId, message);

    }


        private InitRequest buildInitRequest(final String merchantId,
                                             final String transactionId,
                                             final String userId,
                                             final Long amount,
                                             final String orderId,
                                             final String message){
        return InitRequest.builder()
                          .merchantId(merchantId)
                          .transactionId(transactionId)
                          .merchantOrderId(orderId)
                          .merchantUserId(userId)
                          .amount(amount)
                          .message(message)
                          .build();
    }

    private String getGenericMessage(final String orderId){
        return String.format("Payment for orderId: %s", orderId);
    }
}
