/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.APIKeyConfig;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.http.PhonePeException;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.http.utils.HttpUtils;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.models.Base64Request;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.utils.ChecksumUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionInitiator {
    private static final Logger log = LoggerFactory.getLogger(TransactionInitiator.class);
    private TransactionClient transactionClient;
    private InitConfig initConfig;
    private MerchantConfig merchantConfig;

    public TransactionInitiator(TransactionClient transactionClient, InitConfig initConfig, MerchantConfig merchantConfig) {
        this.transactionClient = transactionClient;
        this.initConfig = initConfig;
        this.merchantConfig = merchantConfig;
    }

    public InitResponse initiateTransaction(String transactionId, String userId, Long amount) {
        return this.initiateTransaction(transactionId, "", "", "", "", 1, userId, amount, transactionId);
    }

    public InitResponse initiateTransaction(String transactionId, int keyIndex, String userId, Long amount) {
        return this.initiateTransaction(transactionId, "", "", "", "", keyIndex, userId, amount, transactionId);
    }

    public InitResponse initiateTransaction(String transactionId, int keyIndex, String userId, Long amount, String orderId) {
        return this.initiateTransaction(transactionId, "", "", "", "", keyIndex, userId, amount, orderId);
    }

    public InitResponse initiateTransaction(String transactionId, String redirectMode, String redirectURL, String callbackURL, String callMode, int keyIndex, String userId, Long amount, String orderId) {
        Preconditions.checkNotNull((Object)transactionId);
        Preconditions.checkNotNull((Object)orderId);
        Preconditions.checkNotNull((Object)amount);
        InitResponse initResponse = null;
        try {
            InitRequest initRequest = this.buildInitRequest(this.merchantConfig.getMerchantId(), transactionId, userId, amount, orderId);
            String jsonBody = new ObjectMapper().writeValueAsString((Object)initRequest);
            String b64RequestBody = ChecksumUtils.encodeBase64(jsonBody);
            String apiURL = this.getAPIURL();
            String apiKey = this.getAPIKeyFromIndex(keyIndex);
            String checksumBody = ChecksumUtils.generateChecksumBody(b64RequestBody, apiURL, apiKey);
            String checksumHeader = ChecksumUtils.generateChecksumHeader(checksumBody, keyIndex);
            List<HttpHeaderPair> httpHeaders = this.getHttpHeaders(checksumHeader, this.merchantConfig.getProviderId(), redirectURL, redirectMode, callbackURL, callMode);
            Base64Request base64Request = Base64Request.builder().request(b64RequestBody).build();
            initResponse = this.performTransactionInit(base64Request, httpHeaders, apiURL);
        }
        catch (Exception ex) {
            log.error("Exception occurred");
        }
        return initResponse;
    }

    protected abstract InitRequest buildInitRequest(String var1, String var2, String var3, Long var4, String var5);

    private InitResponse performTransactionInit(Base64Request base64Request, List<HttpHeaderPair> httpHeaders, String apiURL) throws Exception {
        try {
            return this.transactionClient.initTransaction(base64Request, httpHeaders, apiURL);
        }
        catch (Exception ex) {
            throw new Exception();
        }
    }

    private String getAPIURL() {
        return String.format("/%s/debit", this.initConfig.getApiVersion().getApiVersion());
    }

    private List<HttpHeaderPair> getHttpHeaders(String checksumHeader, String providerId, String redirectURL, String redirectMode, String callbackURL, String callMode) {
        ArrayList<HttpHeaderPair> headerPairs = new ArrayList<HttpHeaderPair>();
        HttpHeaderPair checksumHeaderPair = HttpUtils.getHeaderPair("X-VERIFY", checksumHeader);
        headerPairs.add(checksumHeaderPair);
        HttpHeaderPair contentTypeHeaderPair = HttpUtils.getContentTypeHeaderPair();
        headerPairs.add(contentTypeHeaderPair);
        if (StringUtils.isNotEmpty((CharSequence)providerId)) {
            HttpHeaderPair providerIdHeader = HttpUtils.getHeaderPair("X-PROVIDER-ID", providerId);
            headerPairs.add(providerIdHeader);
        }
        if (StringUtils.isNotEmpty((CharSequence)redirectURL)) {
            HttpHeaderPair redirectURLHeader = HttpUtils.getHeaderPair("X-REDIRECT-URL", redirectURL);
            headerPairs.add(redirectURLHeader);
        }
        if (StringUtils.isNotEmpty((CharSequence)redirectMode)) {
            HttpHeaderPair redirectModeHeader = HttpUtils.getHeaderPair("X-REDIRECT-MODE", redirectMode);
            headerPairs.add(redirectModeHeader);
        }
        if (StringUtils.isNotEmpty((CharSequence)callbackURL)) {
            HttpHeaderPair callbackURLHeader = HttpUtils.getHeaderPair("X-CALLBACK-URL", callbackURL);
            headerPairs.add(callbackURLHeader);
        }
        if (StringUtils.isNotEmpty((CharSequence)callMode)) {
            HttpHeaderPair callbackModeHeader = HttpUtils.getHeaderPair("X-CALL-MODE", callMode);
            headerPairs.add(callbackModeHeader);
        }
        return headerPairs;
    }

    private String getAPIKeyFromIndex(int keyIndex) throws Exception {
        for (APIKeyConfig apiKey : this.merchantConfig.getApiKeys()) {
            if (apiKey.getKeyIndex() != keyIndex) continue;
            return apiKey.getKeyValue();
        }
        throw new PhonePeException();
    }
}

