/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.utils;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumUtils {
    private static final Logger log = LoggerFactory.getLogger(ChecksumUtils.class);
    private static final String SEPARATOR_VaLUE = "###";

    public static String generateChecksumHeader(String checksumBody, int apiKeyIndex) {
        String checksumValue = DigestUtils.sha256Hex((String)checksumBody);
        return checksumValue.concat(SEPARATOR_VaLUE).concat(Integer.toString(apiKeyIndex));
    }

    public static String generateChecksumBody(String b64RequestBody, String url, String apiKey) {
        String hex = (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)b64RequestBody) ? b64RequestBody : "").concat(url).concat(apiKey);
        return DigestUtils.sha256Hex((String)hex);
    }

    public static String decodeBase64(String encodedString) {
        return StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)encodedString));
    }

    public static String encodeBase64(String requestString) {
        return StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])requestString.getBytes()));
    }
}

