/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.http.models;

import java.util.Arrays;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.Protocol;

public class ExtractedResponse {
    private final Protocol protocol;
    private final int code;
    private final String message;
    private final Headers headers;
    private final Handshake handshake;
    private final byte[] body;
    private final long sentRequestAtMillis;
    private final long receivedResponseAtMillis;

    public ExtractedResponse(Protocol protocol, int code, String message, Headers headers, Handshake handshake, byte[] body, long sentRequestAtMillis, long receivedResponseAtMillis) {
        this.protocol = protocol;
        this.code = code;
        this.message = message;
        this.headers = headers;
        this.handshake = handshake;
        this.body = body;
        this.sentRequestAtMillis = sentRequestAtMillis;
        this.receivedResponseAtMillis = receivedResponseAtMillis;
    }

    public static ExtractedResponseBuilder builder() {
        return new ExtractedResponseBuilder();
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Handshake getHandshake() {
        return this.handshake;
    }

    public byte[] getBody() {
        return this.body;
    }

    public long getSentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    public long getReceivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtractedResponse)) {
            return false;
        }
        ExtractedResponse other = (ExtractedResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Protocol this$protocol = this.getProtocol();
        Protocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Headers this$headers = this.getHeaders();
        Headers other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        Handshake this$handshake = this.getHandshake();
        Handshake other$handshake = other.getHandshake();
        if (this$handshake == null ? other$handshake != null : !this$handshake.equals(other$handshake)) {
            return false;
        }
        if (!Arrays.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (this.getSentRequestAtMillis() != other.getSentRequestAtMillis()) {
            return false;
        }
        return this.getReceivedResponseAtMillis() == other.getReceivedResponseAtMillis();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExtractedResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Protocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Headers $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        Handshake $handshake = this.getHandshake();
        result = result * 59 + ($handshake == null ? 43 : $handshake.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        long $sentRequestAtMillis = this.getSentRequestAtMillis();
        result = result * 59 + (int)($sentRequestAtMillis >>> 32 ^ $sentRequestAtMillis);
        long $receivedResponseAtMillis = this.getReceivedResponseAtMillis();
        result = result * 59 + (int)($receivedResponseAtMillis >>> 32 ^ $receivedResponseAtMillis);
        return result;
    }

    public String toString() {
        return "ExtractedResponse(protocol=" + this.getProtocol() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", headers=" + this.getHeaders() + ", handshake=" + this.getHandshake() + ", body=" + Arrays.toString(this.getBody()) + ", sentRequestAtMillis=" + this.getSentRequestAtMillis() + ", receivedResponseAtMillis=" + this.getReceivedResponseAtMillis() + ")";
    }

    public static class ExtractedResponseBuilder {
        private Protocol protocol;
        private int code;
        private String message;
        private Headers headers;
        private Handshake handshake;
        private byte[] body;
        private long sentRequestAtMillis;
        private long receivedResponseAtMillis;

        ExtractedResponseBuilder() {
        }

        public ExtractedResponseBuilder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public ExtractedResponseBuilder code(int code) {
            this.code = code;
            return this;
        }

        public ExtractedResponseBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ExtractedResponseBuilder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public ExtractedResponseBuilder handshake(Handshake handshake) {
            this.handshake = handshake;
            return this;
        }

        public ExtractedResponseBuilder body(byte[] body) {
            this.body = body;
            return this;
        }

        public ExtractedResponseBuilder sentRequestAtMillis(long sentRequestAtMillis) {
            this.sentRequestAtMillis = sentRequestAtMillis;
            return this;
        }

        public ExtractedResponseBuilder receivedResponseAtMillis(long receivedResponseAtMillis) {
            this.receivedResponseAtMillis = receivedResponseAtMillis;
            return this;
        }

        public ExtractedResponse build() {
            return new ExtractedResponse(this.protocol, this.code, this.message, this.headers, this.handshake, this.body, this.sentRequestAtMillis, this.receivedResponseAtMillis);
        }

        public String toString() {
            return "ExtractedResponse.ExtractedResponseBuilder(protocol=" + this.protocol + ", code=" + this.code + ", message=" + this.message + ", headers=" + this.headers + ", handshake=" + this.handshake + ", body=" + Arrays.toString(this.body) + ", sentRequestAtMillis=" + this.sentRequestAtMillis + ", receivedResponseAtMillis=" + this.receivedResponseAtMillis + ")";
        }
    }
}

