/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.Endpoint;
import com.phonepe.sdk.javasdk.config.models.HystrixConfig;
import com.phonepe.sdk.javasdk.http.BaseHttpCommand;
import com.phonepe.sdk.javasdk.http.Consumer;
import com.phonepe.sdk.javasdk.http.models.ExtractedResponse;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPostCommand<T>
extends BaseHttpCommand<T> {
    private static final Logger log = LoggerFactory.getLogger(HttpPostCommand.class);

    @Override
    public void preconditions() {
        super.preconditions();
        Preconditions.checkNotNull((Object)this.httpRequest, (Object)"postData cant be null");
    }

    public HttpPostCommand(OkHttpClient client, HystrixConfig hystrixConfig, String command, Endpoint endpoint, String url, List<HttpHeaderPair> headers, PhonePeHttpRequest httpRequest, ObjectMapper mapper, Class<T> responseType, boolean secure, Consumer<Exception, T> exceptionConsumer, Consumer<ExtractedResponse, T> nonSuccessResponseConsumer, TypeReference<T> responseTypeReference) {
        super(client, hystrixConfig, command, endpoint, url, headers, httpRequest, mapper, responseType, secure, exceptionConsumer, nonSuccessResponseConsumer, responseTypeReference);
    }

    @Override
    public Request getRequest(HttpUrl httpUrl) throws JsonProcessingException {
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl).post(this.getRequestBody());
        if (this.headers != null) {
            for (HttpHeaderPair httpHeader : this.headers) {
                requestBuilder.header(httpHeader.getName(), httpHeader.getValue());
            }
        }
        return requestBuilder.build();
    }

    public static <T> HttpPostCommandBuilder<T> builder() {
        return new HttpPostCommandBuilder();
    }

    @Override
    public String toString() {
        return "HttpPostCommand(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpPostCommand)) {
            return false;
        }
        HttpPostCommand other = (HttpPostCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpPostCommand;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class HttpPostCommandBuilder<T> {
        private OkHttpClient client;
        private HystrixConfig hystrixConfig;
        private String command;
        private Endpoint endpoint;
        private String url;
        private ArrayList<HttpHeaderPair> headers;
        private PhonePeHttpRequest httpRequest;
        private ObjectMapper mapper;
        private Class<T> responseType;
        private boolean secure;
        private Consumer<Exception, T> exceptionConsumer;
        private Consumer<ExtractedResponse, T> nonSuccessResponseConsumer;
        private TypeReference<T> responseTypeReference;

        HttpPostCommandBuilder() {
        }

        public HttpPostCommandBuilder<T> client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public HttpPostCommandBuilder<T> hystrixConfig(HystrixConfig hystrixConfig) {
            this.hystrixConfig = hystrixConfig;
            return this;
        }

        public HttpPostCommandBuilder<T> command(String command) {
            this.command = command;
            return this;
        }

        public HttpPostCommandBuilder<T> endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public HttpPostCommandBuilder<T> url(String url) {
            this.url = url;
            return this;
        }

        public HttpPostCommandBuilder<T> header(HttpHeaderPair header) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.add(header);
            return this;
        }

        public HttpPostCommandBuilder<T> headers(Collection<? extends HttpHeaderPair> headers) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.addAll(headers);
            return this;
        }

        public HttpPostCommandBuilder<T> clearHeaders() {
            if (this.headers != null) {
                this.headers.clear();
            }
            return this;
        }

        public HttpPostCommandBuilder<T> httpRequest(PhonePeHttpRequest httpRequest) {
            this.httpRequest = httpRequest;
            return this;
        }

        public HttpPostCommandBuilder<T> mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public HttpPostCommandBuilder<T> responseType(Class<T> responseType) {
            this.responseType = responseType;
            return this;
        }

        public HttpPostCommandBuilder<T> secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public HttpPostCommandBuilder<T> exceptionConsumer(Consumer<Exception, T> exceptionConsumer) {
            this.exceptionConsumer = exceptionConsumer;
            return this;
        }

        public HttpPostCommandBuilder<T> nonSuccessResponseConsumer(Consumer<ExtractedResponse, T> nonSuccessResponseConsumer) {
            this.nonSuccessResponseConsumer = nonSuccessResponseConsumer;
            return this;
        }

        public HttpPostCommandBuilder<T> responseTypeReference(TypeReference<T> responseTypeReference) {
            this.responseTypeReference = responseTypeReference;
            return this;
        }

        public HttpPostCommand<T> build() {
            List<HttpHeaderPair> headers;
            switch (this.headers == null ? 0 : this.headers.size()) {
                case 0: {
                    headers = Collections.emptyList();
                    break;
                }
                case 1: {
                    headers = Collections.singletonList(this.headers.get(0));
                    break;
                }
                default: {
                    headers = Collections.unmodifiableList(new ArrayList<HttpHeaderPair>(this.headers));
                }
            }
            return new HttpPostCommand<T>(this.client, this.hystrixConfig, this.command, this.endpoint, this.url, headers, this.httpRequest, this.mapper, this.responseType, this.secure, this.exceptionConsumer, this.nonSuccessResponseConsumer, this.responseTypeReference);
        }

        public String toString() {
            return "HttpPostCommand.HttpPostCommandBuilder(client=" + this.client + ", hystrixConfig=" + this.hystrixConfig + ", command=" + this.command + ", endpoint=" + this.endpoint + ", url=" + this.url + ", headers=" + this.headers + ", httpRequest=" + this.httpRequest + ", mapper=" + this.mapper + ", responseType=" + this.responseType + ", secure=" + this.secure + ", exceptionConsumer=" + this.exceptionConsumer + ", nonSuccessResponseConsumer=" + this.nonSuccessResponseConsumer + ", responseTypeReference=" + this.responseTypeReference + ")";
        }
    }
}

