package com.phonepe.sdk.javasdk.transaction.callback;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.http.PhonePeException;
import com.phonepe.sdk.javasdk.transaction.status.TransactionStatusChecker;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import com.phonepe.sdk.javasdk.transaction.status.models.TransactionStatusResponse;
import com.phonepe.sdk.javasdk.utils.ChecksumUtils;
import lombok.Builder;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class CallbackHandler {

    private TransactionStatusChecker transactionStatusChecker;

    private MerchantConfig merchantConfig;

    @Builder
    public CallbackHandler(final TransactionStatusChecker transactionStatusChecker,
                           final MerchantConfig merchantConfig) {
        this.transactionStatusChecker = transactionStatusChecker;
        this.merchantConfig = merchantConfig;
    }

    public StatusResponse handleCallback(final String responseReceived, final int keyIndex){
        StatusResponse statusResponse = null;
        try{
            final String responseBody = ChecksumUtils.decodeBase64(responseReceived);
            TransactionStatusResponse transactionStatusResponse = new ObjectMapper().readValue(responseBody,TransactionStatusResponse.class);
            final String merchantId = transactionStatusResponse.getMerchantId();
            if(!isvalidMerchantId(merchantId)){
                throw new PhonePeException();
            }
            final String transactionId = transactionStatusResponse.getTransactionId();
            return this.transactionStatusChecker.checkTransactionStatus(transactionId, keyIndex);
        }catch (Exception ex){
            log.error("Exception occurred while performing transaction status check");
        }
        return statusResponse;
    }

    private boolean isvalidMerchantId(final String merchantId){
        return this.merchantConfig.getMerchantId().equals(merchantId);
    }
}