/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.phonepe.sdk.javasdk.config.ConfigurationFactory;
import com.phonepe.sdk.javasdk.config.models.HttpClientConfig;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.PhonePeSDKConfig;
import com.phonepe.sdk.javasdk.config.models.StatusConfig;
import com.phonepe.sdk.javasdk.http.PhonePeHttpClientFactory;
import com.phonepe.sdk.javasdk.transaction.callback.CallbackHandler;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.init.web.WebTransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.status.TransactionStatusChecker;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import javax.validation.Validation;
import javax.validation.Validator;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhonePeClient {
    private static final Logger log = LoggerFactory.getLogger(PhonePeClient.class);
    private TransactionInitiator transactionInitiator;
    private CallbackHandler callbackHandler;
    private TransactionStatusChecker statusChecker;

    public InitResponse initTransaction(String transactionId, int keyIndex, String userId, Long amount, String orderId) {
        return this.transactionInitiator.initiateTransaction(transactionId, keyIndex, userId, amount, orderId);
    }

    public StatusResponse handleCallback(String responseReceived, int keyIndex) {
        return this.callbackHandler.handleCallback(responseReceived, keyIndex);
    }

    public StatusResponse checkTransactionStatus(String transactionId, int keyIndex) {
        return this.statusChecker.checkTransactionStatus(transactionId, keyIndex);
    }

    public void init() {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
            PhonePeSDKConfig phonePeSDKConfig = new ConfigurationFactory<PhonePeSDKConfig>(PhonePeSDKConfig.class, validator, objectMapper).build();
            HttpClientConfig httpClientConfig = phonePeSDKConfig.getHttpClientConfig();
            StatusConfig statusConfig = phonePeSDKConfig.getStatusConfig();
            MerchantConfig merchantConfig = phonePeSDKConfig.getMerchantConfig();
            InitConfig initConfig = phonePeSDKConfig.getInitConfig();
            OkHttpClient client = PhonePeHttpClientFactory.buildOkHttpClient(httpClientConfig);
            TransactionClient transactionClient = new TransactionClient(httpClientConfig, objectMapper, client);
            this.statusChecker = TransactionStatusChecker.builder().merchantConfig(merchantConfig).statusConfig(statusConfig).transactionClient(transactionClient).build();
            this.callbackHandler = CallbackHandler.builder().merchantConfig(merchantConfig).transactionStatusChecker(this.statusChecker).build();
            this.transactionInitiator = WebTransactionInitiator.builder().initConfig(initConfig).merchantConfig(merchantConfig).transactionClient(transactionClient).build();
        }
        catch (Exception ex) {
            log.error("Exception occurred during PhonePeClient init");
        }
    }
}

