/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.callback;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.http.PhonePeException;
import com.phonepe.sdk.javasdk.transaction.status.TransactionStatusChecker;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import com.phonepe.sdk.javasdk.transaction.status.models.TransactionStatusResponse;
import com.phonepe.sdk.javasdk.utils.ChecksumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(CallbackHandler.class);
    private TransactionStatusChecker transactionStatusChecker;
    private MerchantConfig merchantConfig;

    public CallbackHandler(TransactionStatusChecker transactionStatusChecker, MerchantConfig merchantConfig) {
        this.transactionStatusChecker = transactionStatusChecker;
        this.merchantConfig = merchantConfig;
    }

    public StatusResponse handleCallback(String responseReceived, int keyIndex) {
        StatusResponse statusResponse = null;
        try {
            String responseBody = ChecksumUtils.decodeBase64(responseReceived);
            TransactionStatusResponse transactionStatusResponse = (TransactionStatusResponse)new ObjectMapper().readValue(responseBody, TransactionStatusResponse.class);
            String merchantId = transactionStatusResponse.getMerchantId();
            if (!this.isvalidMerchantId(merchantId)) {
                throw new PhonePeException();
            }
            String transactionId = transactionStatusResponse.getTransactionId();
            return this.transactionStatusChecker.checkTransactionStatus(transactionId, keyIndex);
        }
        catch (Exception ex) {
            log.error("Exception occurred while performing transaction status check");
            return statusResponse;
        }
    }

    private boolean isvalidMerchantId(String merchantId) {
        return this.merchantConfig.getMerchantId().equals(merchantId);
    }

    public static CallbackHandlerBuilder builder() {
        return new CallbackHandlerBuilder();
    }

    public static class CallbackHandlerBuilder {
        private TransactionStatusChecker transactionStatusChecker;
        private MerchantConfig merchantConfig;

        CallbackHandlerBuilder() {
        }

        public CallbackHandlerBuilder transactionStatusChecker(TransactionStatusChecker transactionStatusChecker) {
            this.transactionStatusChecker = transactionStatusChecker;
            return this;
        }

        public CallbackHandlerBuilder merchantConfig(MerchantConfig merchantConfig) {
            this.merchantConfig = merchantConfig;
            return this;
        }

        public CallbackHandler build() {
            return new CallbackHandler(this.transactionStatusChecker, this.merchantConfig);
        }

        public String toString() {
            return "CallbackHandler.CallbackHandlerBuilder(transactionStatusChecker=" + this.transactionStatusChecker + ", merchantConfig=" + this.merchantConfig + ")";
        }
    }
}

