/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.dropwizard.validation.ValidationMethod;
import java.beans.ConstructorProperties;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.validator.routines.EmailValidator;
import org.hibernate.validator.constraints.NotEmpty;

public class ActivateWalletByMerchantRequest {
    @NotNull
    @NotEmpty
    private String merchantId;
    @NotNull
    @NotEmpty
    private String merchantUserId;
    @NotNull
    @NotEmpty
    @Pattern(regexp="^[6789]{1}\\d{9}$", message="Provide a valid phone number")
    private String userPhoneNumber;
    private String email;
    private int termsAndConditionVersion;
    @JsonIgnore
    private static EmailValidator emailValidator = EmailValidator.getInstance();

    @JsonIgnore
    @ValidationMethod(message="Invalid Email")
    public boolean isValid() {
        return this.email == null || emailValidator.isValid(this.email);
    }

    public static ActivateWalletByMerchantRequestBuilder builder() {
        return new ActivateWalletByMerchantRequestBuilder();
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getMerchantUserId() {
        return this.merchantUserId;
    }

    public String getUserPhoneNumber() {
        return this.userPhoneNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public int getTermsAndConditionVersion() {
        return this.termsAndConditionVersion;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public void setMerchantUserId(String merchantUserId) {
        this.merchantUserId = merchantUserId;
    }

    public void setUserPhoneNumber(String userPhoneNumber) {
        this.userPhoneNumber = userPhoneNumber;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setTermsAndConditionVersion(int termsAndConditionVersion) {
        this.termsAndConditionVersion = termsAndConditionVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivateWalletByMerchantRequest)) {
            return false;
        }
        ActivateWalletByMerchantRequest other = (ActivateWalletByMerchantRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$merchantId = this.getMerchantId();
        String other$merchantId = other.getMerchantId();
        if (this$merchantId == null ? other$merchantId != null : !this$merchantId.equals(other$merchantId)) {
            return false;
        }
        String this$merchantUserId = this.getMerchantUserId();
        String other$merchantUserId = other.getMerchantUserId();
        if (this$merchantUserId == null ? other$merchantUserId != null : !this$merchantUserId.equals(other$merchantUserId)) {
            return false;
        }
        String this$userPhoneNumber = this.getUserPhoneNumber();
        String other$userPhoneNumber = other.getUserPhoneNumber();
        if (this$userPhoneNumber == null ? other$userPhoneNumber != null : !this$userPhoneNumber.equals(other$userPhoneNumber)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        return this.getTermsAndConditionVersion() == other.getTermsAndConditionVersion();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivateWalletByMerchantRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $merchantId = this.getMerchantId();
        result = result * 59 + ($merchantId == null ? 43 : $merchantId.hashCode());
        String $merchantUserId = this.getMerchantUserId();
        result = result * 59 + ($merchantUserId == null ? 43 : $merchantUserId.hashCode());
        String $userPhoneNumber = this.getUserPhoneNumber();
        result = result * 59 + ($userPhoneNumber == null ? 43 : $userPhoneNumber.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        result = result * 59 + this.getTermsAndConditionVersion();
        return result;
    }

    public ActivateWalletByMerchantRequest() {
    }

    @ConstructorProperties(value={"merchantId", "merchantUserId", "userPhoneNumber", "email", "termsAndConditionVersion"})
    public ActivateWalletByMerchantRequest(String merchantId, String merchantUserId, String userPhoneNumber, String email, int termsAndConditionVersion) {
        this.merchantId = merchantId;
        this.merchantUserId = merchantUserId;
        this.userPhoneNumber = userPhoneNumber;
        this.email = email;
        this.termsAndConditionVersion = termsAndConditionVersion;
    }

    public String toString() {
        return "ActivateWalletByMerchantRequest(merchantId=" + this.getMerchantId() + ", merchantUserId=" + this.getMerchantUserId() + ", userPhoneNumber=" + this.getUserPhoneNumber() + ", email=" + this.getEmail() + ", termsAndConditionVersion=" + this.getTermsAndConditionVersion() + ")";
    }

    public static class ActivateWalletByMerchantRequestBuilder {
        private String merchantId;
        private String merchantUserId;
        private String userPhoneNumber;
        private String email;
        private int termsAndConditionVersion;

        ActivateWalletByMerchantRequestBuilder() {
        }

        public ActivateWalletByMerchantRequestBuilder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public ActivateWalletByMerchantRequestBuilder merchantUserId(String merchantUserId) {
            this.merchantUserId = merchantUserId;
            return this;
        }

        public ActivateWalletByMerchantRequestBuilder userPhoneNumber(String userPhoneNumber) {
            this.userPhoneNumber = userPhoneNumber;
            return this;
        }

        public ActivateWalletByMerchantRequestBuilder email(String email) {
            this.email = email;
            return this;
        }

        public ActivateWalletByMerchantRequestBuilder termsAndConditionVersion(int termsAndConditionVersion) {
            this.termsAndConditionVersion = termsAndConditionVersion;
            return this;
        }

        public ActivateWalletByMerchantRequest build() {
            return new ActivateWalletByMerchantRequest(this.merchantId, this.merchantUserId, this.userPhoneNumber, this.email, this.termsAndConditionVersion);
        }

        public String toString() {
            return "ActivateWalletByMerchantRequest.ActivateWalletByMerchantRequestBuilder(merchantId=" + this.merchantId + ", merchantUserId=" + this.merchantUserId + ", userPhoneNumber=" + this.userPhoneNumber + ", email=" + this.email + ", termsAndConditionVersion=" + this.termsAndConditionVersion + ")";
        }
    }
}

