/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.common.enums;

import com.phonepe.models.common.enums.PaymentState;
import java.util.Map;

public enum ResponseCode {
    INVALID_RECIPIENTS(400, "Pay request has invalid users"),
    INVALID_REQUEST(401, "Invalid request"),
    DUPLICATE_TXN_REQUEST(402, "Has sent a duplicate transaction id"),
    REMINDER_TOO_FREQUENT(403, "Only one reminder can be sent in a day"),
    INVALID_TRANSACTION_ID(404, "Invalid merchant transaction id"),
    ACCOUNT_NOT_FOUND(406, "Account does not exists"),
    DEVICE_NOT_FOUND(407, "Device does not exists"),
    INVALID_IFSC(408, "No Branch found for IFSC"),
    AUTHORIZATION_FAILED(409, "Auth fail"),
    NO_PRIMARY_VPA(410, "No primary VPA for user"),
    PAYMENT_ALREADY_UNDERWAY(411, "Payment already underway for this request"),
    SPLIT_TO_EXTERNAL_UNSUPPORTED(412, "Multiple payees not allowed in external collect"),
    PAYMENT_ALREADY_COMPLETED(415, "Payment already completed"),
    MERCHANT_MOBILE_COLLECT_UNSUPPORTED(416, "Sorry, payment method unavailable. Please try using VPA / Debit Card / Credit Card"),
    PER_TRANSACTION_LIMIT_EXCEEDED(416, "Transaction Amount is greater than max allowed for this bank"),
    WALLET_TEMPORARY_DISABLED(450, "wallet service is not available"),
    UPI_TEMPORARY_DISABLED(451, "upi service is not available"),
    EGV_TEMPORARY_DISABLED(452, "egv service is not available"),
    CREDIT_CARD_TEMPORARY_DISABLED(453, "credit card service is not available"),
    DEBIT_CARD_TEMPORARY_DISABLED(454, "debit card service is not available"),
    NET_BANKING_TEMPORARY_DISABLED(456, "net banking service is not available"),
    IMPS_TEMPORARY_DISABLED(456, "imps service is not available"),
    BANK_SENDER_ROLE_TEMPORARY_DISABLED(457, "bank sender role is disabled"),
    BANK_RECEIVER_ROLE_TEMPORARY_DISABLED(458, "bank receiver role is disabled"),
    BANK_META_ROLE_TEMPORARY_DISABLED(460, "bank meta role is disabled"),
    BENEFICIARY_BANK_DOES_NOT_SUPPORT_UPI(459, "beneficiary bank not on upi"),
    BANK_UPI_TEMPORARY_DISABLED(459, "Bank UPI is temporarily disabled"),
    WALLET_WITHDRAWAL_UNSUPPORTED_FOR_UPI_BANK(100, "Wallet Withdrawal is not supported for this UPI bank"),
    ORIGINAL_TRANSACTION_NOT_FOUND(100, "Could not identify the original transaction "),
    EXCESS_REFUND_AMOUNT(101, "The refund amount exceeds the maximum refundable amount allowed for this transaction"),
    INSUFFICIENT_FUNDS(103, "There is insufficient balance in the customer's account"),
    INSUFFICIENT_FUNDS_FOR_P2P(103, "There is insufficient balance in the customer's account for transfer"),
    TRANSACTION_NOT_ALLOWED(102, "The transaction is not eligible for the wallet state"),
    WALLET_NOT_FOUND(104, "The wallet does not exists"),
    TRANSACTION_LIMIT_EXCEEDED(105, "Transaction amount has exceeded the txn limit"),
    CREDIT_TXN_LIMIT_EXCEEDED(106, "Credit Transaction amount has exceeded the txn limit"),
    DEBIT_TXN_LIMIT_EXCEEDED(107, "Debit Transaction amount has exceeded the txn limit"),
    OPERATION_NOT_SUPPORTED(108, "Operation not supported"),
    OPERATION_CANT_BE_PERFORMED_IN_THIS_STATE(450, "Operation can't be performed in this state"),
    INVALID_PROGRAM_ID(451, "Invalid program id"),
    INVALID_TOKEN(452, "Invalid token"),
    MISSING_KYC(453, "Missing kyc"),
    AMOUNT_HIGHER_THAN_ALLOWED(454, "Amount higher than max allowed value"),
    CREATED_WITH_DIFFERENT_INVOICE_NUMBER(455, "Created with different invoice number"),
    ORIGINAL_BALANCE_NOT_SAME_AS_CURRENT_BALANCE(456, "Original balance not same as current balance"),
    CARD_EXPIRED(457, "Card expired"),
    CARD_BLOCKED(458, "Card blocked"),
    CARD_DEACTIVATED(459, "Card deactivated"),
    CARD_NOT_ACTIVATED(460, "Card not activated"),
    CARD_CANCELLED(461, "Card cancelled"),
    INVOICE_MISMATCH(462, "Invoice mismatch"),
    AMOUNT_HIGHER_THAN_REDEEM(463, "Amount higher than redeem"),
    CARD_DOESNT_EXIST(464, "Card doesn't exist"),
    NOT_ALLOWED_FOR_PROGRAM(465, "Not allowed for program"),
    CARD_AUTHORIZATION_FAILED(466, "Card auth failed"),
    CARD_AUTHORIZATION_FAILED_CARD_BLOCKED(467, "Card auth failed. Card is blocked"),
    OPERATION_TEMPORARY_UNAVAILABLE(468, "Operation can't be performed at this time"),
    INVALID_KYC(469, "Invalid KYC details"),
    INVALID_REVERSAL_AMOUNT(470, "Invalid Amount for reversal"),
    TXN_AUTO_FAILED(471, "Auto Failed"),
    USER_NOT_FOUND(304, "No user found"),
    USER_SERVICE_EXCEPTION(305, "User service exception"),
    USER_BLACKLISTED(306, "Blacklisted user"),
    DEVICE_NOT_UPI_MAPPED(307, "Device not mapped for UPI"),
    SUCCESS(200, "Successful", PaymentState.COMPLETED),
    CREATED(204, "The transaction has been initiated", PaymentState.CREATED),
    PENDING(205, "The transaction is currently pending", PaymentState.ONBOARDING_REQUESTED),
    INTERNAL_SERVER_ERROR(500, "Server Error "),
    DAO_EXCEPTION(501, "Data Access Error "),
    QUEUE_EXCEPTION(502, "Error while pushing to queue"),
    FEED_SERVICE_EXCEPTION(503, "Feed service exception"),
    FLIPCAST_SERVICE_EXCEPTION(504, "Flipcast exception"),
    REVOLVER_SERVICE_EXCEPTION(505, "Revolver exception"),
    WALLET_SERVICE_EXCEPTION(506, "Wallet service exception"),
    ACCOUNTING_SERVICE_EXCEPTION(507, "Accounting service exception"),
    EVENT_SERVICE_EXCEPTION(508, "Event Ingestion service exception"),
    NON_RETRYABLE_TRANSACTION(509, "Cannot retry this transaction"),
    REQUEST_FAILED(510, "Collect request failed at UPI"),
    REQUEST_TIME_OUT(511, "Request Timed out"),
    MERCHANT_SERVICE_EXCEPTION(512, "Merchant service exception"),
    PROMOTION_SERVICE_EXCEPTION(513, "Promotions service exception"),
    GIFTCARD_SERVICE_EXCEPTION(514, "Gift card service exception"),
    MERCURY_SERVICE_EXCEPTION(514, "mercury service exception"),
    OFFERENGINE_EXCEPTION(515, "Offer engine exception"),
    VAULT_SERVICE_EXCEPTION(516, "Vault service exception"),
    PG_BACKBONE_ERROR(605, "Error in PG backbone"),
    UPI_BACKBONE_ERROR(601, "Error in UPI backbone"),
    IMPS_BACKBONE_ERROR(601, "Error in IMPS backbone"),
    WALLET_BACKBONE_ERROR(601, "Error in Wallet"),
    EGV_BACKBONE_ERROR(601, "Error in EGV"),
    REQUEST_CANCEL_BY_REQUESTER(602, "User canceled the request"),
    REQUEST_DECLINE_BY_REQUESTEE(603, "User Declined the request"),
    CRED_BLOCK_NOT_FOUND(604, "Mpin missed"),
    INVALID_CARD(606, "Wrong card details"),
    CARD_NOT_SUPPORTED(607, "Card not supported"),
    CREDIT_CARD_NOT_SUPPORTED(608, "Credit Card not supported"),
    BLOCKED_FRAUD(700, "Transaction blocked due to suspected fraud"),
    INVALID_QR_CODE(800, "Invalid QR Code"),
    INVALID_DEVICE(801, "Invalid Device"),
    INVALID_INTENT(802, "Invalid intent"),
    JSON_ERROR(900, "Invalid Json"),
    CONCURRENT_REVERSAL(901, "Concurrent reversal for promotions"),
    CACHE_ERROR(902, "Cache error"),
    HTTP_ERROR(903, "Http error"),
    CAMPAIGN_NOT_FOUND(904, "No campaign found"),
    NO_MATCHING_CAMPAIGN(904, "No matching campaign"),
    OFFER_NOT_FOUND(905, "No offer found"),
    NO_MATCHING_OFFER(905, "No matching offer"),
    CONNECTION_ERROR(906, "Connection Error"),
    INTERNAL_ERROR(907, "Internal Server Error"),
    DUPLICATE_DISBURSEMENT(908, "Duplicate Disbursement"),
    OFFER_ALREADY_EXISTS(909, "Duplicate Offer"),
    INVALID_DISBURSEMENT_AMOUNT(910, "Invalid disbursement Amount"),
    RETRIES_EXHAUSTED(911, "Retries Exhausted"),
    ILLEGAL_JSON_PATH(912, "Invalid Json Path"),
    UNKNOWN_ERROR(913, "Unknown Error"),
    CONCURRENT_DISBURSAL(914, "Concurrent disbursals"),
    SERIALIZATION_ERROR(915, "Serialization Error"),
    DESERIALIZATION_ERROR(916, "Deserialization Error"),
    UPDATE_CONSTRAINT_ERROR(917, "Constraint updation Error"),
    CONSTRAINT_VALIDATION_ERROR(918, "Constraint Validation Error"),
    READ_CONSTRAINT_ERROR(919, "Constraint Read Error"),
    INVALID_PATH_ERROR(920, "Invalid Path Error"),
    INVALID_DATA_TYPE_ERROR(921, "Invalid Data type Error"),
    ILLEGAL_STATE_EXCEPTION(922, "Illegal State Error"),
    IMMUTABLE_OFFER(923, "Immutable Offer Error"),
    INVALID_CALCULATION(924, "Invalid Calculation"),
    REFERENCE_RESOLUTION_FAILURE(925, "Reference Resolution Failure"),
    NO_DISBURSEMENT_FOUND(926, "No Disbursement Found"),
    ROLLBACK_FAILURE(927, "Version Rollback Failure"),
    INVALID_STATE_TRANSITION(928, "Invalid Offerlife cycle transition"),
    ILLEGAL_ARGUMENT_EXCEPTION(929, "Illegal Argument Exception"),
    DISCOUNT_INITIATION_ERROR(930, "Discount Initiation Error");

    private final String message;
    private final PaymentState state;
    private final int code;

    private ResponseCode(int code, String msg, PaymentState state) {
        this.code = code;
        this.message = msg;
        this.state = state;
    }

    private ResponseCode(int code, String msg) {
        this.code = code;
        this.message = msg;
        this.state = PaymentState.FAILED;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessage(Map<String, String> params) {
        String message = this.message;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            message = message.replace('<' + entry.getKey() + '>', entry.getValue());
        }
        return message;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isSuccess() {
        return this.state == PaymentState.COMPLETED;
    }
}

