/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.request;

import com.phonepe.models.common.enums.CurrencyCode;
import com.phonepe.models.common.user.User;
import com.phonepe.models.request.BaseRequest;
import java.beans.ConstructorProperties;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

public class ToaRequest
extends BaseRequest {
    @NotNull
    @NotEmpty
    @Length(min=1, max=64)
    private String merchantTransactionId;
    @NotNull
    @NotEmpty
    @Length(min=1, max=64)
    private String message;

    public ToaRequest(User user, long amount, CurrencyCode currencyCode) {
        super(user, amount, currencyCode);
    }

    public ToaRequest(User user, long amount, CurrencyCode currencyCode, String merchantTransactionId, String message) {
        this(user, amount, currencyCode);
        this.merchantTransactionId = merchantTransactionId;
        this.message = message;
    }

    public static ToaRequestBuilder builder() {
        return new ToaRequestBuilder();
    }

    public String getMerchantTransactionId() {
        return this.merchantTransactionId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMerchantTransactionId(String merchantTransactionId) {
        this.merchantTransactionId = merchantTransactionId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToaRequest)) {
            return false;
        }
        ToaRequest other = (ToaRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$merchantTransactionId = this.getMerchantTransactionId();
        String other$merchantTransactionId = other.getMerchantTransactionId();
        if (this$merchantTransactionId == null ? other$merchantTransactionId != null : !this$merchantTransactionId.equals(other$merchantTransactionId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ToaRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $merchantTransactionId = this.getMerchantTransactionId();
        result = result * 59 + ($merchantTransactionId == null ? 43 : $merchantTransactionId.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @ConstructorProperties(value={"merchantTransactionId", "message"})
    public ToaRequest(String merchantTransactionId, String message) {
        this.merchantTransactionId = merchantTransactionId;
        this.message = message;
    }

    public ToaRequest() {
    }

    @Override
    public String toString() {
        return "ToaRequest(super=" + super.toString() + ", merchantTransactionId=" + this.getMerchantTransactionId() + ", message=" + this.getMessage() + ")";
    }

    public static class ToaRequestBuilder {
        private User user;
        private long amount;
        private CurrencyCode currencyCode;
        private String merchantTransactionId;
        private String message;

        ToaRequestBuilder() {
        }

        public ToaRequestBuilder user(User user) {
            this.user = user;
            return this;
        }

        public ToaRequestBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public ToaRequestBuilder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public ToaRequestBuilder merchantTransactionId(String merchantTransactionId) {
            this.merchantTransactionId = merchantTransactionId;
            return this;
        }

        public ToaRequestBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ToaRequest build() {
            return new ToaRequest(this.user, this.amount, this.currencyCode, this.merchantTransactionId, this.message);
        }

        public String toString() {
            return "ToaRequest.ToaRequestBuilder(user=" + this.user + ", amount=" + this.amount + ", currencyCode=" + (Object)((Object)this.currencyCode) + ", merchantTransactionId=" + this.merchantTransactionId + ", message=" + this.message + ")";
        }
    }
}

