/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.response;

import com.phonepe.models.common.enums.CurrencyCode;
import com.phonepe.models.common.enums.MerchantRequestType;
import com.phonepe.models.common.enums.PaymentState;
import com.phonepe.models.common.enums.ResponseCode;
import java.beans.ConstructorProperties;

public class PaymentResponse {
    private PaymentState paymentState;
    private ResponseCode responseCode;
    private String backendErrorCode;
    private long amount;
    private CurrencyCode currencyCode = CurrencyCode.INR;
    private String transactionId;
    private String merchantTransactionId;
    private String merchantOrderId;
    private MerchantRequestType merchantRequestType;
    private String collectRequestId;

    public static PaymentResponseBuilder builder() {
        return new PaymentResponseBuilder();
    }

    public PaymentState getPaymentState() {
        return this.paymentState;
    }

    public ResponseCode getResponseCode() {
        return this.responseCode;
    }

    public String getBackendErrorCode() {
        return this.backendErrorCode;
    }

    public long getAmount() {
        return this.amount;
    }

    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getMerchantTransactionId() {
        return this.merchantTransactionId;
    }

    public String getMerchantOrderId() {
        return this.merchantOrderId;
    }

    public MerchantRequestType getMerchantRequestType() {
        return this.merchantRequestType;
    }

    public String getCollectRequestId() {
        return this.collectRequestId;
    }

    public void setPaymentState(PaymentState paymentState) {
        this.paymentState = paymentState;
    }

    public void setResponseCode(ResponseCode responseCode) {
        this.responseCode = responseCode;
    }

    public void setBackendErrorCode(String backendErrorCode) {
        this.backendErrorCode = backendErrorCode;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setMerchantTransactionId(String merchantTransactionId) {
        this.merchantTransactionId = merchantTransactionId;
    }

    public void setMerchantOrderId(String merchantOrderId) {
        this.merchantOrderId = merchantOrderId;
    }

    public void setMerchantRequestType(MerchantRequestType merchantRequestType) {
        this.merchantRequestType = merchantRequestType;
    }

    public void setCollectRequestId(String collectRequestId) {
        this.collectRequestId = collectRequestId;
    }

    public PaymentResponse() {
    }

    @ConstructorProperties(value={"paymentState", "responseCode", "backendErrorCode", "amount", "currencyCode", "transactionId", "merchantTransactionId", "merchantOrderId", "merchantRequestType", "collectRequestId"})
    public PaymentResponse(PaymentState paymentState, ResponseCode responseCode, String backendErrorCode, long amount, CurrencyCode currencyCode, String transactionId, String merchantTransactionId, String merchantOrderId, MerchantRequestType merchantRequestType, String collectRequestId) {
        this.paymentState = paymentState;
        this.responseCode = responseCode;
        this.backendErrorCode = backendErrorCode;
        this.amount = amount;
        this.currencyCode = currencyCode;
        this.transactionId = transactionId;
        this.merchantTransactionId = merchantTransactionId;
        this.merchantOrderId = merchantOrderId;
        this.merchantRequestType = merchantRequestType;
        this.collectRequestId = collectRequestId;
    }

    public String toString() {
        return "PaymentResponse(paymentState=" + (Object)((Object)this.getPaymentState()) + ", responseCode=" + (Object)((Object)this.getResponseCode()) + ", backendErrorCode=" + this.getBackendErrorCode() + ", amount=" + this.getAmount() + ", currencyCode=" + (Object)((Object)this.getCurrencyCode()) + ", transactionId=" + this.getTransactionId() + ", merchantTransactionId=" + this.getMerchantTransactionId() + ", merchantOrderId=" + this.getMerchantOrderId() + ", merchantRequestType=" + (Object)((Object)this.getMerchantRequestType()) + ", collectRequestId=" + this.getCollectRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentResponse)) {
            return false;
        }
        PaymentResponse other = (PaymentResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PaymentState this$paymentState = this.getPaymentState();
        PaymentState other$paymentState = other.getPaymentState();
        if (this$paymentState == null ? other$paymentState != null : !((Object)((Object)this$paymentState)).equals((Object)other$paymentState)) {
            return false;
        }
        ResponseCode this$responseCode = this.getResponseCode();
        ResponseCode other$responseCode = other.getResponseCode();
        if (this$responseCode == null ? other$responseCode != null : !((Object)((Object)this$responseCode)).equals((Object)other$responseCode)) {
            return false;
        }
        String this$backendErrorCode = this.getBackendErrorCode();
        String other$backendErrorCode = other.getBackendErrorCode();
        if (this$backendErrorCode == null ? other$backendErrorCode != null : !this$backendErrorCode.equals(other$backendErrorCode)) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        CurrencyCode this$currencyCode = this.getCurrencyCode();
        CurrencyCode other$currencyCode = other.getCurrencyCode();
        if (this$currencyCode == null ? other$currencyCode != null : !((Object)((Object)this$currencyCode)).equals((Object)other$currencyCode)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$merchantTransactionId = this.getMerchantTransactionId();
        String other$merchantTransactionId = other.getMerchantTransactionId();
        if (this$merchantTransactionId == null ? other$merchantTransactionId != null : !this$merchantTransactionId.equals(other$merchantTransactionId)) {
            return false;
        }
        String this$merchantOrderId = this.getMerchantOrderId();
        String other$merchantOrderId = other.getMerchantOrderId();
        if (this$merchantOrderId == null ? other$merchantOrderId != null : !this$merchantOrderId.equals(other$merchantOrderId)) {
            return false;
        }
        MerchantRequestType this$merchantRequestType = this.getMerchantRequestType();
        MerchantRequestType other$merchantRequestType = other.getMerchantRequestType();
        if (this$merchantRequestType == null ? other$merchantRequestType != null : !((Object)((Object)this$merchantRequestType)).equals((Object)other$merchantRequestType)) {
            return false;
        }
        String this$collectRequestId = this.getCollectRequestId();
        String other$collectRequestId = other.getCollectRequestId();
        return !(this$collectRequestId == null ? other$collectRequestId != null : !this$collectRequestId.equals(other$collectRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PaymentState $paymentState = this.getPaymentState();
        result = result * 59 + ($paymentState == null ? 43 : ((Object)((Object)$paymentState)).hashCode());
        ResponseCode $responseCode = this.getResponseCode();
        result = result * 59 + ($responseCode == null ? 43 : ((Object)((Object)$responseCode)).hashCode());
        String $backendErrorCode = this.getBackendErrorCode();
        result = result * 59 + ($backendErrorCode == null ? 43 : $backendErrorCode.hashCode());
        long $amount = this.getAmount();
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        CurrencyCode $currencyCode = this.getCurrencyCode();
        result = result * 59 + ($currencyCode == null ? 43 : ((Object)((Object)$currencyCode)).hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $merchantTransactionId = this.getMerchantTransactionId();
        result = result * 59 + ($merchantTransactionId == null ? 43 : $merchantTransactionId.hashCode());
        String $merchantOrderId = this.getMerchantOrderId();
        result = result * 59 + ($merchantOrderId == null ? 43 : $merchantOrderId.hashCode());
        MerchantRequestType $merchantRequestType = this.getMerchantRequestType();
        result = result * 59 + ($merchantRequestType == null ? 43 : ((Object)((Object)$merchantRequestType)).hashCode());
        String $collectRequestId = this.getCollectRequestId();
        result = result * 59 + ($collectRequestId == null ? 43 : $collectRequestId.hashCode());
        return result;
    }

    public static class PaymentResponseBuilder {
        private PaymentState paymentState;
        private ResponseCode responseCode;
        private String backendErrorCode;
        private long amount;
        private CurrencyCode currencyCode;
        private String transactionId;
        private String merchantTransactionId;
        private String merchantOrderId;
        private MerchantRequestType merchantRequestType;
        private String collectRequestId;

        PaymentResponseBuilder() {
        }

        public PaymentResponseBuilder paymentState(PaymentState paymentState) {
            this.paymentState = paymentState;
            return this;
        }

        public PaymentResponseBuilder responseCode(ResponseCode responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public PaymentResponseBuilder backendErrorCode(String backendErrorCode) {
            this.backendErrorCode = backendErrorCode;
            return this;
        }

        public PaymentResponseBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public PaymentResponseBuilder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public PaymentResponseBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public PaymentResponseBuilder merchantTransactionId(String merchantTransactionId) {
            this.merchantTransactionId = merchantTransactionId;
            return this;
        }

        public PaymentResponseBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public PaymentResponseBuilder merchantRequestType(MerchantRequestType merchantRequestType) {
            this.merchantRequestType = merchantRequestType;
            return this;
        }

        public PaymentResponseBuilder collectRequestId(String collectRequestId) {
            this.collectRequestId = collectRequestId;
            return this;
        }

        public PaymentResponse build() {
            return new PaymentResponse(this.paymentState, this.responseCode, this.backendErrorCode, this.amount, this.currencyCode, this.transactionId, this.merchantTransactionId, this.merchantOrderId, this.merchantRequestType, this.collectRequestId);
        }

        public String toString() {
            return "PaymentResponse.PaymentResponseBuilder(paymentState=" + (Object)((Object)this.paymentState) + ", responseCode=" + (Object)((Object)this.responseCode) + ", backendErrorCode=" + this.backendErrorCode + ", amount=" + this.amount + ", currencyCode=" + (Object)((Object)this.currencyCode) + ", transactionId=" + this.transactionId + ", merchantTransactionId=" + this.merchantTransactionId + ", merchantOrderId=" + this.merchantOrderId + ", merchantRequestType=" + (Object)((Object)this.merchantRequestType) + ", collectRequestId=" + this.collectRequestId + ")";
        }
    }
}

