/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.request;

import com.phonepe.models.common.enums.CurrencyCode;
import com.phonepe.models.common.user.User;
import com.phonepe.models.request.BaseRequest;
import java.beans.ConstructorProperties;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

public class CashbackRequest
extends BaseRequest {
    @NotNull
    @NotEmpty
    @Length(min=1, max=64)
    private String merchantTransactionId;
    @NotNull
    @NotEmpty
    @Length(min=1, max=64)
    private String merchantOrderId;
    private String message;
    @Length(min=0, max=64)
    private String campaignId;

    public CashbackRequest(User user, long amount, CurrencyCode currencyCode) {
        super(user, amount, currencyCode);
    }

    public CashbackRequest(User user, long amount, CurrencyCode currencyCode, String merchantTransactionId, String merchantOrderId, String campaignId, String message) {
        this(user, amount, currencyCode);
        this.merchantTransactionId = merchantTransactionId;
        this.merchantOrderId = merchantOrderId;
        this.message = message;
        this.campaignId = campaignId;
    }

    public static CashbackRequestBuilder builder() {
        return new CashbackRequestBuilder();
    }

    public String getMerchantTransactionId() {
        return this.merchantTransactionId;
    }

    public String getMerchantOrderId() {
        return this.merchantOrderId;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public void setMerchantTransactionId(String merchantTransactionId) {
        this.merchantTransactionId = merchantTransactionId;
    }

    public void setMerchantOrderId(String merchantOrderId) {
        this.merchantOrderId = merchantOrderId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CashbackRequest)) {
            return false;
        }
        CashbackRequest other = (CashbackRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$merchantTransactionId = this.getMerchantTransactionId();
        String other$merchantTransactionId = other.getMerchantTransactionId();
        if (this$merchantTransactionId == null ? other$merchantTransactionId != null : !this$merchantTransactionId.equals(other$merchantTransactionId)) {
            return false;
        }
        String this$merchantOrderId = this.getMerchantOrderId();
        String other$merchantOrderId = other.getMerchantOrderId();
        if (this$merchantOrderId == null ? other$merchantOrderId != null : !this$merchantOrderId.equals(other$merchantOrderId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$campaignId = this.getCampaignId();
        String other$campaignId = other.getCampaignId();
        return !(this$campaignId == null ? other$campaignId != null : !this$campaignId.equals(other$campaignId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CashbackRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $merchantTransactionId = this.getMerchantTransactionId();
        result = result * 59 + ($merchantTransactionId == null ? 43 : $merchantTransactionId.hashCode());
        String $merchantOrderId = this.getMerchantOrderId();
        result = result * 59 + ($merchantOrderId == null ? 43 : $merchantOrderId.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $campaignId = this.getCampaignId();
        result = result * 59 + ($campaignId == null ? 43 : $campaignId.hashCode());
        return result;
    }

    @ConstructorProperties(value={"merchantTransactionId", "merchantOrderId", "message", "campaignId"})
    public CashbackRequest(String merchantTransactionId, String merchantOrderId, String message, String campaignId) {
        this.merchantTransactionId = merchantTransactionId;
        this.merchantOrderId = merchantOrderId;
        this.message = message;
        this.campaignId = campaignId;
    }

    public CashbackRequest() {
    }

    @Override
    public String toString() {
        return "CashbackRequest(super=" + super.toString() + ", merchantTransactionId=" + this.getMerchantTransactionId() + ", merchantOrderId=" + this.getMerchantOrderId() + ", message=" + this.getMessage() + ", campaignId=" + this.getCampaignId() + ")";
    }

    public static class CashbackRequestBuilder {
        private User user;
        private long amount;
        private CurrencyCode currencyCode;
        private String merchantTransactionId;
        private String merchantOrderId;
        private String campaignId;
        private String message;

        CashbackRequestBuilder() {
        }

        public CashbackRequestBuilder user(User user) {
            this.user = user;
            return this;
        }

        public CashbackRequestBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public CashbackRequestBuilder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public CashbackRequestBuilder merchantTransactionId(String merchantTransactionId) {
            this.merchantTransactionId = merchantTransactionId;
            return this;
        }

        public CashbackRequestBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public CashbackRequestBuilder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public CashbackRequestBuilder message(String message) {
            this.message = message;
            return this;
        }

        public CashbackRequest build() {
            return new CashbackRequest(this.user, this.amount, this.currencyCode, this.merchantTransactionId, this.merchantOrderId, this.campaignId, this.message);
        }

        public String toString() {
            return "CashbackRequest.CashbackRequestBuilder(user=" + this.user + ", amount=" + this.amount + ", currencyCode=" + (Object)((Object)this.currencyCode) + ", merchantTransactionId=" + this.merchantTransactionId + ", merchantOrderId=" + this.merchantOrderId + ", campaignId=" + this.campaignId + ", message=" + this.message + ")";
        }
    }
}

