/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.common.transaction.impl;

import com.phonepe.models.common.enums.OriginalTransactionType;
import com.phonepe.models.common.transaction.OriginalTransaction;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

public class MerchantOriginalTransaction
extends OriginalTransaction {
    @NotNull
    @NotEmpty
    @Length(min=1, max=64)
    private String transactionId;

    public MerchantOriginalTransaction() {
        super(OriginalTransactionType.MERCHANT_TRANSACTION);
    }

    public MerchantOriginalTransaction(String transactionId) {
        this();
        this.transactionId = transactionId;
    }

    public static MerchantOriginalTransactionBuilder builder() {
        return new MerchantOriginalTransactionBuilder();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MerchantOriginalTransaction)) {
            return false;
        }
        MerchantOriginalTransaction other = (MerchantOriginalTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        return !(this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MerchantOriginalTransaction;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MerchantOriginalTransaction(super=" + super.toString() + ", transactionId=" + this.getTransactionId() + ")";
    }

    public static class MerchantOriginalTransactionBuilder {
        private String transactionId;

        MerchantOriginalTransactionBuilder() {
        }

        public MerchantOriginalTransactionBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public MerchantOriginalTransaction build() {
            return new MerchantOriginalTransaction(this.transactionId);
        }

        public String toString() {
            return "MerchantOriginalTransaction.MerchantOriginalTransactionBuilder(transactionId=" + this.transactionId + ")";
        }
    }
}

