/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.common.enums;

public enum WalletState {
    PERMANENTLY_BLOCKED(-40),
    BLOCKED(-30),
    EXPIRED(-20),
    NOT_FOUND(0),
    FAILED_TO_CREATE(10),
    MERGED(20),
    CREATED(30),
    ACTIVATED(70);

    private int stateCode;

    private WalletState(int stateCode) {
        this.stateCode = stateCode;
    }

    public int getStateCode() {
        return this.stateCode;
    }

    public boolean isWalletActive() {
        return this.stateCode >= 70;
    }

    public boolean isEligibleForDeDupeChecks() {
        return this != EXPIRED && this != PERMANENTLY_BLOCKED;
    }

    public boolean isEligibleForTransaction() {
        return this.stateCode >= 20;
    }

    public boolean isEligibleForWalletCreation() {
        return this == NOT_FOUND;
    }
}

