/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.request;

import com.phonepe.models.common.User;
import com.phonepe.models.common.enums.BankAccountType;
import com.phonepe.models.common.enums.CurrencyCode;
import com.phonepe.models.request.BaseRequest;
import java.beans.ConstructorProperties;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

public class MoveoutRequest
extends BaseRequest {
    @NotNull
    @NotEmpty
    @Length(min=1, max=64)
    private String merchantTransactionId;
    @NotNull
    @NotEmpty
    @Length(min=1, max=255)
    private String accountNumber;
    @NotNull
    @NotEmpty
    @Pattern(regexp="^[a-zA-Z0-9.]{11}$")
    private String ifsc;
    @NotNull
    private BankAccountType bankAccountType;
    private String bankBranch;
    private String message;

    public MoveoutRequest(User user, long amount, CurrencyCode currencyCode) {
        super(user, amount, currencyCode);
    }

    public MoveoutRequest(String merchantTransactionId, String accountNumber, String ifsc, BankAccountType bankAccountType, String message, User user, long amount, CurrencyCode currencyCode) {
        this(user, amount, currencyCode);
        this.merchantTransactionId = merchantTransactionId;
        this.accountNumber = accountNumber;
        this.bankAccountType = bankAccountType;
        this.ifsc = ifsc;
        this.message = message;
    }

    public static MoveoutRequestBuilder builder() {
        return new MoveoutRequestBuilder();
    }

    public String getMerchantTransactionId() {
        return this.merchantTransactionId;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public String getIfsc() {
        return this.ifsc;
    }

    public BankAccountType getBankAccountType() {
        return this.bankAccountType;
    }

    public String getBankBranch() {
        return this.bankBranch;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMerchantTransactionId(String merchantTransactionId) {
        this.merchantTransactionId = merchantTransactionId;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public void setIfsc(String ifsc) {
        this.ifsc = ifsc;
    }

    public void setBankAccountType(BankAccountType bankAccountType) {
        this.bankAccountType = bankAccountType;
    }

    public void setBankBranch(String bankBranch) {
        this.bankBranch = bankBranch;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MoveoutRequest)) {
            return false;
        }
        MoveoutRequest other = (MoveoutRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$merchantTransactionId = this.getMerchantTransactionId();
        String other$merchantTransactionId = other.getMerchantTransactionId();
        if (this$merchantTransactionId == null ? other$merchantTransactionId != null : !this$merchantTransactionId.equals(other$merchantTransactionId)) {
            return false;
        }
        String this$accountNumber = this.getAccountNumber();
        String other$accountNumber = other.getAccountNumber();
        if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
            return false;
        }
        String this$ifsc = this.getIfsc();
        String other$ifsc = other.getIfsc();
        if (this$ifsc == null ? other$ifsc != null : !this$ifsc.equals(other$ifsc)) {
            return false;
        }
        BankAccountType this$bankAccountType = this.getBankAccountType();
        BankAccountType other$bankAccountType = other.getBankAccountType();
        if (this$bankAccountType == null ? other$bankAccountType != null : !((Object)((Object)this$bankAccountType)).equals((Object)other$bankAccountType)) {
            return false;
        }
        String this$bankBranch = this.getBankBranch();
        String other$bankBranch = other.getBankBranch();
        if (this$bankBranch == null ? other$bankBranch != null : !this$bankBranch.equals(other$bankBranch)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MoveoutRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $merchantTransactionId = this.getMerchantTransactionId();
        result = result * 59 + ($merchantTransactionId == null ? 43 : $merchantTransactionId.hashCode());
        String $accountNumber = this.getAccountNumber();
        result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
        String $ifsc = this.getIfsc();
        result = result * 59 + ($ifsc == null ? 43 : $ifsc.hashCode());
        BankAccountType $bankAccountType = this.getBankAccountType();
        result = result * 59 + ($bankAccountType == null ? 43 : ((Object)((Object)$bankAccountType)).hashCode());
        String $bankBranch = this.getBankBranch();
        result = result * 59 + ($bankBranch == null ? 43 : $bankBranch.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @ConstructorProperties(value={"merchantTransactionId", "accountNumber", "ifsc", "bankAccountType", "bankBranch", "message"})
    public MoveoutRequest(String merchantTransactionId, String accountNumber, String ifsc, BankAccountType bankAccountType, String bankBranch, String message) {
        this.merchantTransactionId = merchantTransactionId;
        this.accountNumber = accountNumber;
        this.ifsc = ifsc;
        this.bankAccountType = bankAccountType;
        this.bankBranch = bankBranch;
        this.message = message;
    }

    public MoveoutRequest() {
    }

    @Override
    public String toString() {
        return "MoveoutRequest(super=" + super.toString() + ", merchantTransactionId=" + this.getMerchantTransactionId() + ", accountNumber=" + this.getAccountNumber() + ", ifsc=" + this.getIfsc() + ", bankAccountType=" + (Object)((Object)this.getBankAccountType()) + ", bankBranch=" + this.getBankBranch() + ", message=" + this.getMessage() + ")";
    }

    public static class MoveoutRequestBuilder {
        private String merchantTransactionId;
        private String accountNumber;
        private String ifsc;
        private BankAccountType bankAccountType;
        private String message;
        private User user;
        private long amount;
        private CurrencyCode currencyCode;

        MoveoutRequestBuilder() {
        }

        public MoveoutRequestBuilder merchantTransactionId(String merchantTransactionId) {
            this.merchantTransactionId = merchantTransactionId;
            return this;
        }

        public MoveoutRequestBuilder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public MoveoutRequestBuilder ifsc(String ifsc) {
            this.ifsc = ifsc;
            return this;
        }

        public MoveoutRequestBuilder bankAccountType(BankAccountType bankAccountType) {
            this.bankAccountType = bankAccountType;
            return this;
        }

        public MoveoutRequestBuilder message(String message) {
            this.message = message;
            return this;
        }

        public MoveoutRequestBuilder user(User user) {
            this.user = user;
            return this;
        }

        public MoveoutRequestBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public MoveoutRequestBuilder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public MoveoutRequest build() {
            return new MoveoutRequest(this.merchantTransactionId, this.accountNumber, this.ifsc, this.bankAccountType, this.message, this.user, this.amount, this.currencyCode);
        }

        public String toString() {
            return "MoveoutRequest.MoveoutRequestBuilder(merchantTransactionId=" + this.merchantTransactionId + ", accountNumber=" + this.accountNumber + ", ifsc=" + this.ifsc + ", bankAccountType=" + (Object)((Object)this.bankAccountType) + ", message=" + this.message + ", user=" + this.user + ", amount=" + this.amount + ", currencyCode=" + (Object)((Object)this.currencyCode) + ")";
        }
    }
}

