/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.common;

import com.phonepe.models.common.User;
import com.phonepe.models.common.enums.UserType;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

public class MerchantUser
extends User {
    @NotNull
    @NotEmpty
    @Length(min=1, max=64)
    private String id;
    private String phoneNumber;
    private String emailId;

    public MerchantUser() {
        super(UserType.MERCHANT_USER_ID);
    }

    public MerchantUser(String id, String phoneNumber, String emailId) {
        this();
        this.id = id;
        this.phoneNumber = phoneNumber;
        this.emailId = emailId;
    }

    public static MerchantUserBuilder builder() {
        return new MerchantUserBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MerchantUser)) {
            return false;
        }
        MerchantUser other = (MerchantUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$phoneNumber = this.getPhoneNumber();
        String other$phoneNumber = other.getPhoneNumber();
        if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) {
            return false;
        }
        String this$emailId = this.getEmailId();
        String other$emailId = other.getEmailId();
        return !(this$emailId == null ? other$emailId != null : !this$emailId.equals(other$emailId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MerchantUser;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $phoneNumber = this.getPhoneNumber();
        result = result * 59 + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
        String $emailId = this.getEmailId();
        result = result * 59 + ($emailId == null ? 43 : $emailId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MerchantUser(super=" + super.toString() + ", id=" + this.getId() + ", phoneNumber=" + this.getPhoneNumber() + ", emailId=" + this.getEmailId() + ")";
    }

    public static class MerchantUserBuilder {
        private String id;
        private String phoneNumber;
        private String emailId;

        MerchantUserBuilder() {
        }

        public MerchantUserBuilder id(String id) {
            this.id = id;
            return this;
        }

        public MerchantUserBuilder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public MerchantUserBuilder emailId(String emailId) {
            this.emailId = emailId;
            return this;
        }

        public MerchantUser build() {
            return new MerchantUser(this.id, this.phoneNumber, this.emailId);
        }

        public String toString() {
            return "MerchantUser.MerchantUserBuilder(id=" + this.id + ", phoneNumber=" + this.phoneNumber + ", emailId=" + this.emailId + ")";
        }
    }
}

