/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.request;

import com.phonepe.models.common.User;
import com.phonepe.models.common.enums.CurrencyCode;
import com.phonepe.models.request.BaseRequest;
import java.beans.ConstructorProperties;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

public class RedeemRequest
extends BaseRequest {
    @NotNull
    @NotEmpty
    @Length(min=1, max=64)
    String merchantTransactionId;
    @NotNull
    @NotEmpty
    @Length(min=1, max=64)
    String merchantOrderId;
    private String message;

    public RedeemRequest(User user, long amount, CurrencyCode currencyCode) {
        super(user, amount, currencyCode);
    }

    public RedeemRequest(User user, long amount, CurrencyCode currencyCode, String merchantTransactionId, String merchantOrderId, String message) {
        this(user, amount, currencyCode);
        this.merchantTransactionId = merchantTransactionId;
        this.merchantOrderId = merchantOrderId;
        this.message = message;
    }

    public static RedeemRequestBuilder builder() {
        return new RedeemRequestBuilder();
    }

    public String getMerchantTransactionId() {
        return this.merchantTransactionId;
    }

    public String getMerchantOrderId() {
        return this.merchantOrderId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMerchantTransactionId(String merchantTransactionId) {
        this.merchantTransactionId = merchantTransactionId;
    }

    public void setMerchantOrderId(String merchantOrderId) {
        this.merchantOrderId = merchantOrderId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedeemRequest)) {
            return false;
        }
        RedeemRequest other = (RedeemRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$merchantTransactionId = this.getMerchantTransactionId();
        String other$merchantTransactionId = other.getMerchantTransactionId();
        if (this$merchantTransactionId == null ? other$merchantTransactionId != null : !this$merchantTransactionId.equals(other$merchantTransactionId)) {
            return false;
        }
        String this$merchantOrderId = this.getMerchantOrderId();
        String other$merchantOrderId = other.getMerchantOrderId();
        if (this$merchantOrderId == null ? other$merchantOrderId != null : !this$merchantOrderId.equals(other$merchantOrderId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RedeemRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $merchantTransactionId = this.getMerchantTransactionId();
        result = result * 59 + ($merchantTransactionId == null ? 43 : $merchantTransactionId.hashCode());
        String $merchantOrderId = this.getMerchantOrderId();
        result = result * 59 + ($merchantOrderId == null ? 43 : $merchantOrderId.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @ConstructorProperties(value={"merchantTransactionId", "merchantOrderId", "message"})
    public RedeemRequest(String merchantTransactionId, String merchantOrderId, String message) {
        this.merchantTransactionId = merchantTransactionId;
        this.merchantOrderId = merchantOrderId;
        this.message = message;
    }

    public RedeemRequest() {
    }

    @Override
    public String toString() {
        return "RedeemRequest(super=" + super.toString() + ", merchantTransactionId=" + this.getMerchantTransactionId() + ", merchantOrderId=" + this.getMerchantOrderId() + ", message=" + this.getMessage() + ")";
    }

    public static class RedeemRequestBuilder {
        private User user;
        private long amount;
        private CurrencyCode currencyCode;
        private String merchantTransactionId;
        private String merchantOrderId;
        private String message;

        RedeemRequestBuilder() {
        }

        public RedeemRequestBuilder user(User user) {
            this.user = user;
            return this;
        }

        public RedeemRequestBuilder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public RedeemRequestBuilder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public RedeemRequestBuilder merchantTransactionId(String merchantTransactionId) {
            this.merchantTransactionId = merchantTransactionId;
            return this;
        }

        public RedeemRequestBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public RedeemRequestBuilder message(String message) {
            this.message = message;
            return this;
        }

        public RedeemRequest build() {
            return new RedeemRequest(this.user, this.amount, this.currencyCode, this.merchantTransactionId, this.merchantOrderId, this.message);
        }

        public String toString() {
            return "RedeemRequest.RedeemRequestBuilder(user=" + this.user + ", amount=" + this.amount + ", currencyCode=" + (Object)((Object)this.currencyCode) + ", merchantTransactionId=" + this.merchantTransactionId + ", merchantOrderId=" + this.merchantOrderId + ", message=" + this.message + ")";
        }
    }
}

