/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.common.enums;

import com.phonepe.models.common.enums.PaymentState;
import java.util.Map;

public enum ResponseCode {
    INVALID_RECIPIENTS(400, "Pay request has invalid users"),
    INVALID_REQUEST(401, "Invalid request"),
    DUPLICATE_TXN_REQUEST(402, "Has sent a duplicate transaction id"),
    ORIGINAL_TRANSACTION_NOT_FOUND(100, "Could not identify the original transaction "),
    EXCESS_REFUND_AMOUNT(101, "The refund amount exceeds the maximum refundable amount allowed for this transaction"),
    INSUFFICIENT_FUNDS(103, "There is insufficient balance in the customer's account"),
    TRANSACTION_NOT_ALLOWED(102, "The transaction is not eligible for the wallet state"),
    WALLET_NOT_FOUND(104, "The wallet does not exists"),
    TRANSACTION_LIMIT_EXCEEDED(105, "Transaction amount has exceeded the txn limit"),
    USER_SERVICE_EXCEPTION(305, "User service exception"),
    USER_NOT_FOUND(304, "Noo user found"),
    SUCCESS(200, "Successful", PaymentState.COMPLETED),
    CREATED(204, "The transaction has been initiated", PaymentState.CREATED),
    PENDING(205, "The transaction is currently pending", PaymentState.ONBOARDING_REQUESTED),
    INTERNAL_SERVER_ERROR(500, "Server Error ");

    private final String message;
    private final PaymentState state;
    private final int code;

    private ResponseCode(int code, String msg, PaymentState state) {
        this.code = code;
        this.message = msg;
        this.state = state;
    }

    private ResponseCode(int code, String msg) {
        this.code = code;
        this.message = msg;
        this.state = PaymentState.FAILED;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessage(Map<String, String> params) {
        String message = this.message;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            message = message.replace('<' + entry.getKey() + '>', entry.getValue());
        }
        return message;
    }

    public boolean isSuccess() {
        return this.state == PaymentState.COMPLETED;
    }
}

