/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.models.common.enums;

import com.phonepe.models.common.enums.PaymentState;
import java.util.Map;

public enum ResponseCode {
    INVALID_RECIPIENTS("Pay request has invalid users"),
    DUPLICATE_TXN_REQUEST("Has sent a duplicate transaction id"),
    WALLET_NOT_FOUND("The wallet does not exists"),
    INSUFFICIENT_FUNDS("There is insufficient balance in the customer's account"),
    ORIGINAL_TRANSACTION_NOT_FOUND("Could not identify the original transaction "),
    INTERNAL_SERVER_ERROR("Server Error "),
    TRANSACTION_NOT_ALLOWED("The transaction is not eligible for the wallet state"),
    TRANSACTION_LIMIT_EXCEEDED("Transaction amount has exceeded the txn limit"),
    INVALID_REQUEST("Invalid request"),
    EXCESS_REFUND_AMOUNT("The refund amount exceeds the maximum refundable amount allowed for this transaction"),
    USER_SERVICE_EXCEPTION("User service exception"),
    USER_NOT_FOUND("Noo user found"),
    CREATED("The transaction has been initiated", PaymentState.CREATED),
    PENDING("The transaction is currently pending", PaymentState.ONBOARDING_REQUESTED),
    SUCCESS("Successful", PaymentState.COMPLETED);

    private final String message;
    private final PaymentState state;

    private ResponseCode(String msg, PaymentState state) {
        this.message = msg;
        this.state = state;
    }

    private ResponseCode(String msg) {
        this.message = msg;
        this.state = PaymentState.FAILED;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessage(Map<String, String> params) {
        String message = this.message;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            message = message.replace('<' + entry.getKey() + '>', entry.getValue());
        }
        return message;
    }

    public boolean isSuccess() {
        return this.state == PaymentState.COMPLETED;
    }
}

