package com.phonepe.intent.sdk.wallettopup.network.response;

import android.support.annotation.NonNull;

import com.phonepe.intent.sdk.api.PhonePe;
import com.phonepe.intent.sdk.api.PhonePeInitException;
import com.phonepe.intent.sdk.models.DefaultJsonImpl;

import org.json.JSONObject;

public class WalletBalanceResponse extends DefaultJsonImpl {

    private static final String KEY_SUCCESS = "success";
    private static final String KEY_CODE = "code";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_DATA = "data";

    public Boolean getSuccess() {
        return get(KEY_SUCCESS);
    }

    public void setSuccess(@NonNull Boolean success) {
        put(KEY_SUCCESS, success);
    }

    public String getCode() {
        return get(KEY_CODE);
    }

    public void setCode(@NonNull String code) {
        put(KEY_CODE, code);
    }

    public String getMessage() {
        return get(KEY_MESSAGE);
    }

    public void setMessage(String message) {
        put(KEY_MESSAGE, message);
    }

    // TODO: find a better way of doing this
    public WalletBalanceData getData() throws PhonePeInitException {
        return fromJsonString(get(KEY_DATA).toString(), PhonePe.getObjectFactory(), WalletBalanceData.class);
    }

    public void setData(@NonNull JSONObject data){
        put(KEY_DATA, data);
    }

    public static class WalletBalanceData extends DefaultJsonImpl {

        public static class Wallet extends DefaultJsonImpl {

            private static final String KEY_AVAILABLE_BALANCE = "availableBalance";
            private static final String KEY_USABLE_BALANCE = "usableBalance";
            private static final String KEY_MAX_TOPUP_ALLOWED = "maxTopupAllowed";
            private static final String KEY_CODE = "responseCode";
            private static final String KEY_WALLET_ACTIVE = "walletActive";
            private static final String KEY_WALLET_TOPUP_SUGGESTED = "walletTopupSuggested";

            public Integer getAvailableBalance() { return get(KEY_AVAILABLE_BALANCE); }

            public void setAvailableBalance(@NonNull Long availableBalance) { put(KEY_AVAILABLE_BALANCE, availableBalance); }

            public Integer getUsableBalance() { return get(KEY_USABLE_BALANCE); }

            public void setUsableBalance(long usableBalance) { put(KEY_USABLE_BALANCE, usableBalance); }

            public Integer getMaxTopupAllowed() {
                return get(KEY_MAX_TOPUP_ALLOWED);
            }

            public void setMaxTopupAllowed(@NonNull Long maxTopupAllowed) { put(KEY_MAX_TOPUP_ALLOWED, maxTopupAllowed); }

            public String getCode() {
                return get(KEY_CODE);
            }

            public void setCode(@NonNull String code) {
                put(KEY_CODE, code);
            }

            public Boolean getWalletActive() {
                return get(KEY_WALLET_ACTIVE);
            }

            public void setWalletActive(@NonNull Boolean walletActive) { put(KEY_WALLET_ACTIVE, walletActive); }

            public Boolean getWalletTopUpSuggested() {
                return get(KEY_WALLET_TOPUP_SUGGESTED);
            }

            public void setWalletTopupSuggested(@NonNull Boolean walletTopupSuggested) { put(KEY_WALLET_TOPUP_SUGGESTED, walletTopupSuggested); }

        }
        private static final String KEY_USER_ID = "userIdHash";
        private static final String KEY_MERCHANT_ID = "merchantId";
        private static final String KEY_WALLET = "wallet";
        private static final String KEY_MASKED_MOBILE_NUMBER = "maskedMobileNumber";
        private static final String KEY_ALLOW_PARTIAL_PAYMENT = "allowPartialPayment";
        private static final String KEY_LINKED_USER = "linkedUser";
        private static final String KEY_UPI = "upi";

        public String getUserId() {
            return get(KEY_USER_ID);
        }

        public void setUserId(String userId) { put(KEY_USER_ID, userId); }

        public Boolean getLinkedUser() {
            return get(KEY_LINKED_USER);
        }

        public void setLinkedUser(Boolean linkedUser) { put(KEY_LINKED_USER, linkedUser); }

        public String getAllowPartialPayment() {
            return get(KEY_ALLOW_PARTIAL_PAYMENT);
        }

        public void setAllowPartialPayment(String allowPartialPayment) { put(KEY_ALLOW_PARTIAL_PAYMENT, allowPartialPayment); }

        public void setUpi(JSONObject upi){
            put(KEY_UPI, upi);
        }

        public String getMerchantId() {
            return get(KEY_MERCHANT_ID);
        }

        public void setMerchantId(@NonNull String merchantId) {
            put(KEY_MERCHANT_ID, merchantId);
        }

        public Wallet getWallet() throws PhonePeInitException {
            return fromJsonString(get(KEY_WALLET).toString(), PhonePe.getObjectFactory(), Wallet.class);
        }

        public void setWallet(@NonNull JSONObject wallet){
            put(KEY_WALLET, wallet);
        }

        public String getMaskedMobileNumber() {
            return get(KEY_MASKED_MOBILE_NUMBER);
        }

        public void setMaskedMobileNumber(String maskedMobileNumber) {
            put(KEY_MASKED_MOBILE_NUMBER, maskedMobileNumber);
        }

    }

}
