package com.phonepe.intent.sdk.wallettopup.network.request;

import android.support.annotation.NonNull;

import com.phonepe.intent.sdk.api.PhonePe;
import com.phonepe.intent.sdk.api.PhonePeInitException;
import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.models.DefaultJsonImpl;
import com.phonepe.intent.sdk.utils.AnalyticsManager;
import com.phonepe.intent.sdk.utils.SdkLogger;
import com.phonepe.intent.sdk.utils.Utils;

import static com.phonepe.intent.sdk.utils.AnalyticsManager.Events.SDK_DEBIT_SUGGEST_REQUEST_CREATED;

public class WalletTopUpRequest extends DefaultJsonImpl {

    private String checksum;
    private String data;

    public String getChecksum() {
        return checksum;
    }

    public String getData() {
        return data;
    }

    public static class WalletTopUpRequestBuilder {

        private static final String TAG = "WalletTopUpRequest";
        private String data;
        private String checksum;

        public WalletTopUpRequestBuilder setChecksum(@NonNull String checksum) {
            this.checksum = checksum;
            return this;
        }

        public WalletTopUpRequestBuilder setData(@NonNull String data) {
            this.data = data;
            return this;
        }

        public WalletTopUpRequest build() {

            if (Utils.isNullOrEmpty(this.checksum)) {
                SdkLogger.e(TAG, "Setting checksum is mandatory.");
                throw new RuntimeException("Setting checksum is mandatory.");
            }

            if (Utils.isNullOrEmpty(this.data)) {
                SdkLogger.e(TAG, "Setting data is mandatory.");
                throw new RuntimeException("Setting data is mandatory.");
            }

            WalletTopUpRequest walletTopUpRequest = new WalletTopUpRequest();
            walletTopUpRequest.checksum = this.checksum;
            walletTopUpRequest.data = this.data;

            ObjectFactory objectFactory = null;
            try {
                objectFactory = PhonePe.getObjectFactory();
                AnalyticsManager analyticsManager = objectFactory.<AnalyticsManager>get(AnalyticsManager.class);
                analyticsManager.submit(analyticsManager.getEvent(SDK_DEBIT_SUGGEST_REQUEST_CREATED));
            } catch (PhonePeInitException e) {
                SdkLogger.e(TAG, e.getMessage(), e);
            }
            return walletTopUpRequest;
        }
    }


}