package com.phonepe.intent.sdk.utils;

import android.net.Uri;

import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.core.ObjectFactoryInitializationStrategy;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Config implements ObjectFactoryInitializationStrategy {

    public static final String TAG = "PPConfig";
    private final Executor executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 2, 100, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));

    private interface TransactionPresenterConfig {

        int retryLimit = 1;
    }

    private interface Applications {
        String PP_APP_PACKAGE_UAT_INTERNAL = "com.phonepe.app.preprod.internal";
        String PP_APP_PACKAGE_UAT = "com.phonepe.app.preprod";
        String PP_APP_PACKAGE_STAGE = "com.phonepe.app.debug";
        String PP_APP_PACKAGE_STAGE_INTERNAL = "com.phonepe.app.debug.internal";
        String PP_APP_PACKAGE = "com.phonepe.app";
        String FK_APP_PACKAGE = "com.flipkart.app";
    }

    private interface UpiRegistrationServiceConfig {
        long SECOND = 1000L;
        long DAY = 24 * 60 * 60 * SECOND;
        long UPI_KEY_ROTATION_TIME = 15 * DAY * SECOND;
        long POLLING_INTERVAL = 3 * SECOND;
        int PAYMENT_STATUS_VERIFICATION_RETRIES = 18;

    }

    private interface UtilsConfig {

        String PP_SDK_CACHE_DIR = "phonepesdkcache";
        /**
         * 1 MB Cache size
         */
        int PP_SDK_CACHE_DIR_SIZE = 1024 * 1024;

        String JUST_PAY_SDK_CLASS_NAME = "in.juspay.juspaysafe.BrowserCallback";
        String DEFAULT_APPLICATION_NAME = "application";
    }

    private interface BaseWebActivityConfig {

        String ERROR_STATUS_MESSAGE_WITH_RETRY_BUTTON = "%s\n"
                + Constants.GenericConstants.PLEASE_TRY_AGAIN;
        String ERROR_STATUS_MESSAGE_WITHOUT_RETRY_BUTTON = ERROR_STATUS_MESSAGE_WITH_RETRY_BUTTON + "\n\n" + Constants.GenericConstants.REDIRECTING_BACK + "%s.";

        String WEB_URL_FORMAT = "javascript:%s('%s'  , '%s' , '%s' , '%s')";
    }

    private interface OpenUpiIntentWorkflowConfig {

        String UPI_SCHEME = "upi";
        String UPI_AUTHORITY = "pay";
        String URI_SYNTEX = "%s://%s";
        Uri UPI_DATA_URI = Uri.parse(String.format(URI_SYNTEX, UPI_SCHEME, UPI_AUTHORITY));
    }

    @Override
    public void init(ObjectFactory objectFactory, ObjectFactory.InitializationBundle initializationBundle) {

    }

    @Override
    public boolean isCachingAllowed() {
        return true;
    }

    public int getTransactionPresenterRetryLimit() {

        return TransactionPresenterConfig.retryLimit;
    }

    public String getPhonePeAppPackageName() {

        return Applications.PP_APP_PACKAGE;
    }

    public String getPhonePeUatPackageName() {

        return Applications.PP_APP_PACKAGE_UAT;
    }

    public String getPhonePeUatInternalPackageName() {

        return Applications.PP_APP_PACKAGE_UAT_INTERNAL;
    }

    public String getPhonePeStagePackageName() {
        return Applications.PP_APP_PACKAGE_STAGE;
    }

    public String getPhonePeStageInternalPackageName() {
        return Applications.PP_APP_PACKAGE_STAGE_INTERNAL;
    }

    public String getFlipkartAppPackageName() {

        return Applications.FK_APP_PACKAGE;
    }

    public String getPhonePeSdkCacheDir() {

        return UtilsConfig.PP_SDK_CACHE_DIR;
    }

    public int getPhonePeSdkCacheSize() {

        return UtilsConfig.PP_SDK_CACHE_DIR_SIZE;
    }

    public String getJustPaySdkClassName() {

        return UtilsConfig.JUST_PAY_SDK_CLASS_NAME;
    }

    public String getDefaultAppNamePlaceHolder() {

        return UtilsConfig.DEFAULT_APPLICATION_NAME;
    }

    public String getErrorStatusMessageFormat(boolean showRetry) {


        return showRetry ? BaseWebActivityConfig.ERROR_STATUS_MESSAGE_WITH_RETRY_BUTTON : BaseWebActivityConfig.ERROR_STATUS_MESSAGE_WITHOUT_RETRY_BUTTON;
    }

    public String getWebUrlFormat() {

        return BaseWebActivityConfig.WEB_URL_FORMAT;
    }

    public Uri getUpiUri() {

        return OpenUpiIntentWorkflowConfig.UPI_DATA_URI;
    }

    public long getUpiRegistrationKeyRotationTime() {

        return UpiRegistrationServiceConfig.UPI_KEY_ROTATION_TIME;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ScheduledExecutorService getPollingExecutor() {
        return Executors.newScheduledThreadPool(1);
    }

    public long getUpiRegistrationPollingInterval() {
        return UpiRegistrationServiceConfig.POLLING_INTERVAL;
    }

    public int getStatusCheckMaxRetryCount(){

        return UpiRegistrationServiceConfig.PAYMENT_STATUS_VERIFICATION_RETRIES;
    }
}
