package com.phonepe.intent.sdk.utils;

import android.annotation.TargetApi;
import android.os.Build;
import android.util.Base64;

import java.lang.reflect.Method;

/**
 * @author Ankit Jain
 * @since 08/05/17.
 */

public class BullsEye {

    public static final String TAG = "BullsEye";
    private static BullsEye bullsEye;

    //Hidden default constructor
    private BullsEye() {
    }

    /**
     * Get the device fingerprint
     *
     * @return device fingerprint string
     */
    public static String fingerprint(String androidId) {
        if (bullsEye == null) {
            bullsEye = new BullsEye();
        }
        return androidId + bullsEye.deviceId();
    }

    //Default Id method with multiple fallbacks
    @TargetApi(Build.VERSION_CODES.FROYO)
    public String deviceId() {
        String serial;
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method getSerial = clazz.getMethod("get", String.class);
            serial = (String) getSerial.invoke(clazz, "ro.serialno");
            SdkLogger.d(TAG, "Successfully fetched serial from primary readonly source");
        } catch (Exception ignored) {
            SdkLogger.d("PhonePe", "Failed to fetch serial from primary readonly source");
            serial = null;
        }
        if (serial != null) {
            return safeEncode(Build.BOARD) +
                    '-' +
                    safeEncode(Build.HARDWARE) +
                    '-' +
                    safeEncode(serial);
        } else throw new IllegalStateException("No device id can be generated!");
    }

    private String safeEncode(final String data) {
        final String safe = data.trim().replaceAll("[\r\n]", "");
        return Base64.encodeToString(safe.getBytes(), Base64.URL_SAFE | Base64.NO_WRAP | Base64.NO_PADDING);
    }
}
