package com.phonepe.intent.sdk.ui.adapters;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.app.Activity;
import android.app.Dialog;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.phonepe.intent.sdk.R;
import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.models.ApplicationInfo;
import com.phonepe.intent.sdk.models.Event;
import com.phonepe.intent.sdk.networking.models.RedirectResponse;
import com.phonepe.intent.sdk.utils.AnalyticsManager;
import com.phonepe.intent.sdk.utils.Utils;

import static com.phonepe.intent.sdk.ui.UpiAppsSelectionDialogActivity.DEEP_LINK_REQUEST_CODE;
import static com.phonepe.intent.sdk.utils.AnalyticsManager.EventConstants.APP_NAME;
import static com.phonepe.intent.sdk.utils.AnalyticsManager.Events.SDK_UPI_APP_SELECTION_ACTIVITY_STARTED;
import static com.phonepe.intent.sdk.utils.AnalyticsManager.Events.SDK_UPI_APP_STARTED;

public class UpiAppsGridViewAdapter extends BaseAdapter {


    private Activity activity;
    private RedirectResponse redirectResponse;
    private ObjectFactory objectFactory;
    private Dialog dialog;
    private AnalyticsManager analyticsManager;


    public UpiAppsGridViewAdapter(Activity activity, RedirectResponse redirectResponse, ObjectFactory objectFactory, Dialog dialog) {
       this.activity = activity;
       this.redirectResponse = redirectResponse;
       this.objectFactory = objectFactory;
       this.dialog = dialog;
        this.analyticsManager = this.objectFactory.<AnalyticsManager>get(AnalyticsManager.class);
    }

    @Override
    public int getCount() {
        return redirectResponse.getUpiApps().size();
    }

    @Override
    public ApplicationInfo getItem(int position) {
        return redirectResponse.getUpiApps().get(position);
    }

    @Override
    public long getItemId(int position) {
        return redirectResponse.getUpiApps().get(position).hashCode();
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {

        final ApplicationInfo applicationInfo = getItem(position);
        convertView = LinearLayout.inflate(activity, R.layout.upi_apps_dialog_unit_item,null);
        ((TextView)convertView.findViewById(R.id.app_name)).setText(applicationInfo.getAppName());
        ((ImageView)convertView.findViewById(R.id.app_icon)).setImageDrawable(Utils.getAppIcon(applicationInfo.getPackageName(), objectFactory));
        convertView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                startUpiApp(applicationInfo);
            }
        });
        return convertView;
    }

    private void startUpiApp(@NonNull ApplicationInfo applicationInfo) {

        Event event = this.analyticsManager.getEvent(SDK_UPI_APP_STARTED).putInEventBody(APP_NAME, applicationInfo.getAppName());
        this.analyticsManager.submit(event);

        Intent startIntent = applicationInfo.getIntent();
        startIntent.setAction(Intent.ACTION_VIEW);
        startIntent.setData(Uri.parse(redirectResponse.getRedirectUrl()));
        applicationInfo.markAtLastUsed();
        dialog.dismiss();
        activity.startActivityForResult(startIntent, DEEP_LINK_REQUEST_CODE);
    }
}
