package com.phonepe.intent.sdk.ui;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.TextView;

import com.phonepe.intent.sdk.R;
import com.phonepe.intent.sdk.api.TransactionRequest;
import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.models.Event;
import com.phonepe.intent.sdk.models.IntentResponse;
import com.phonepe.intent.sdk.models.Params;
import com.phonepe.intent.sdk.models.Response;
import com.phonepe.intent.sdk.models.SDKContext;
import com.phonepe.intent.sdk.models.TransactionStatus;
import com.phonepe.intent.sdk.networking.APIHelper;
import com.phonepe.intent.sdk.networking.APIManager;
import com.phonepe.intent.sdk.networking.INetworkResponseListener;
import com.phonepe.intent.sdk.networking.NetworkConstants;
import com.phonepe.intent.sdk.networking.models.RedirectResponse;
import com.phonepe.intent.sdk.ui.adapters.UpiAppsGridViewAdapter;
import com.phonepe.intent.sdk.utils.AnalyticsManager;
import com.phonepe.intent.sdk.utils.Config;
import com.phonepe.intent.sdk.utils.Constants;
import com.phonepe.intent.sdk.utils.CryptLib;
import com.phonepe.intent.sdk.utils.SdkLogger;
import com.phonepe.intent.sdk.utils.Utils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import static com.phonepe.intent.sdk.utils.AnalyticsManager.EventConstants.ERROR_MESSAGE;
import static com.phonepe.intent.sdk.utils.AnalyticsManager.EventConstants.SDK_FLOW_TYPE;
import static com.phonepe.intent.sdk.utils.AnalyticsManager.Events.SDK_BACK_BUTTON_CLICKED;
import static com.phonepe.intent.sdk.utils.AnalyticsManager.Events.SDK_NETWORK_ERROR;
import static com.phonepe.intent.sdk.utils.AnalyticsManager.Events.SDK_TRANSACTION_TOKEN_RECEIVED;
import static com.phonepe.intent.sdk.utils.AnalyticsManager.Events.SDK_UPI_APP_SELECTION_ACTIVITY_STARTED;

public class UpiAppsSelectionDialogActivity extends Activity implements INetworkResponseListener, Dialog.OnKeyListener, DialogInterface.OnCancelListener {

    public static final int DEEP_LINK_REQUEST_CODE = 1234;
    public static final String TAG = "UpiAppsSelectionDialogActivity";
    private static final String TIME_STAMP = "timeStamp";
    private ObjectFactory objectFactory;
    private TransactionRequest transactionRequest;
    private SDKContext sdkContext;
    private APIHelper apiHelper;
    private Dialog dialog;
    private RedirectResponse redirectResponse;
    private AnalyticsManager analyticsManager;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        if(savedInstanceState != null) {
            this.objectFactory = savedInstanceState.getParcelable(Constants.BundleConstants.DATA_FACTORY);
            this.redirectResponse = savedInstanceState.getParcelable(Constants.BundleConstants.KEY_REDIRECT_RESPONSE);
            this.transactionRequest = savedInstanceState.getParcelable(Constants.BundleConstants.KEY_REQUEST);
            this.sdkContext = savedInstanceState.getParcelable(Constants.BundleConstants.KEY_SDK_CONTEXT);
            this.analyticsManager = this.objectFactory.<AnalyticsManager>get(AnalyticsManager.class);
            this.apiHelper = this.objectFactory.<APIHelper>get(APIHelper.class);
        } else if (getIntent() != null && getIntent().getExtras() != null && this.redirectResponse == null) {

            this.objectFactory = getIntent().<ObjectFactory>getParcelableExtra(Constants.BundleConstants.DATA_FACTORY);
            this.analyticsManager = this.objectFactory.<AnalyticsManager>get(AnalyticsManager.class);

            dialog = new ActivityImplicitIntentDialog(this, R.style.phonepeThemeInvisible, objectFactory);
            dialog.setContentView(R.layout.upi_apps_dialog_layout);
            dialog.setCancelable(true);
            dialog.setOnCancelListener(this);
            dialog.setOnKeyListener(this);
            dialog.getWindow().getAttributes().windowAnimations = R.style.DialogAnimation;
            ((TextView) dialog.findViewById(R.id.pay_via_text_view)).setText(R.string.getting_apps);
            startLoadingAnimation(dialog);
            dialog.show();

            this.apiHelper = this.objectFactory.<APIHelper>get(APIHelper.class);
            this.transactionRequest = getIntent().getParcelableExtra(Constants.BundleConstants.KEY_REQUEST);
            this.sdkContext = getIntent().getParcelableExtra(Constants.BundleConstants.KEY_SDK_CONTEXT);
            this.apiHelper.getTransactionRedirectUrl(transactionRequest, this.sdkContext, null, this);

            Event event = this.analyticsManager.getEvent(SDK_UPI_APP_SELECTION_ACTIVITY_STARTED).putInEventBody(SDK_FLOW_TYPE, Constants.RedirectType.OPEN_INTENT);
            this.analyticsManager.submit(event);

        }
    }

    private void startLoadingAnimation(@NonNull Dialog dialog) {

        View viewOne = dialog.findViewById(R.id.circle_one);
        View viewTwo = dialog.findViewById(R.id.circle_two);
        View viewThree = dialog.findViewById(R.id.circle_three);
        View viewFour = dialog.findViewById(R.id.circle_four);

        int offset = 0;
        int offsetDiff = 150;
        int duration = 450;
        viewOne.startAnimation(getAnimation(viewOne, offset, duration));

        offset += offsetDiff;
        viewTwo.startAnimation(getAnimation(viewTwo, offset, duration));

        offset += offsetDiff;
        viewThree.startAnimation(getAnimation(viewThree, offset, duration));

        offset += offsetDiff;
        viewFour.startAnimation(getAnimation(viewFour, offset, duration));
    }

    private Animation getAnimation(@NonNull final View view, int offset, int duration) {

        final Animation animationFadeIn = new AlphaAnimation(0.5f, 1.0f);
        final Animation animationFadeOut = new AlphaAnimation(1.0f, 0.5f);
        animationFadeIn.setDuration(duration);
        animationFadeIn.setStartOffset(offset);
        animationFadeIn.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {

            }

            @Override
            public void onAnimationEnd(Animation animation) {

                view.startAnimation(animationFadeOut);
            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });


        animationFadeOut.setDuration(duration);
        animationFadeOut.setStartOffset(offset);
        animationFadeOut.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {


            }

            @Override
            public void onAnimationEnd(Animation animation) {

                view.startAnimation(animationFadeIn);
            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });

        return animationFadeIn;
    }


    /**
     * This is overridden to consume all touch events on this activity
     */
    @Override
    public boolean onTouchEvent(MotionEvent event) {
        return true;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {

        if (requestCode == DEEP_LINK_REQUEST_CODE) {
            setResult(resultCode, data);
            finish();
        }
    }


    private void setError(@NonNull Intent data, int resultCode, Response response) {

        data.putExtra(Constants.GenericConstants.KEY_TRANSACTION_RESULT, response.toJsonString());
        setResult(resultCode, data);
        finish();
    }

    @Override
    public void onBackPressed() {

        if (dialog != null) {

            dialog.dismiss();
        }

        Event event = this.analyticsManager.getEvent(SDK_NETWORK_ERROR).putInEventBody(ERROR_MESSAGE, SDK_BACK_BUTTON_CLICKED);
        this.analyticsManager.submit(event);

        setError(new Intent(), RESULT_CANCELED, this.objectFactory.getResponse(Constants.GenericConstants.USER_CANCEL));
    }

    @Override
    public void onSuccess(String response) {

        redirectResponse = RedirectResponse.fromJsonString(response, this.objectFactory, RedirectResponse.class);
        if (redirectResponse == null) {

            Event event = this.analyticsManager.getEvent(SDK_NETWORK_ERROR).putInEventBody(ERROR_MESSAGE, response);
            this.analyticsManager.submit(event);
            setError(new Intent(), RESULT_CANCELED,this.objectFactory.getResponse(Constants.GenericConstants.FAILED_TO_CONNECT_TO_SERVER));
            return;
        }

        Event event = this.analyticsManager.getEvent(SDK_TRANSACTION_TOKEN_RECEIVED);
        this.analyticsManager.submit(event);

        dialog.findViewById(R.id.loading_animation).setVisibility(View.GONE);
        if (redirectResponse.getUpiApps() == null || redirectResponse.getUpiApps().isEmpty()) {

            dialog.findViewById(R.id.error_container).setVisibility(View.VISIBLE);
            return;
        }

        ((TextView) dialog.findViewById(R.id.pay_via_text_view)).setText(R.string.pay_via);
        GridView gridview = (GridView) dialog.findViewById(R.id.gridview);
        gridview.setVisibility(View.VISIBLE);
        gridview.setAdapter(new UpiAppsGridViewAdapter(UpiAppsSelectionDialogActivity.this, redirectResponse, objectFactory, UpiAppsSelectionDialogActivity.this.dialog));
    }

    @Override
    public void onFailure(int responseCode, String error) {

        Event event = this.analyticsManager.getEvent(SDK_NETWORK_ERROR).putInEventBody(ERROR_MESSAGE, error);
        this.analyticsManager.submit(event);
        dialog.findViewById(R.id.loading_animation).setVisibility(View.GONE);

        if (dialog != null) {

            dialog.findViewById(R.id.error_container).setVisibility(View.VISIBLE);
            ((TextView) dialog.findViewById(R.id.error_message)).setText(R.string.error_message);
        }
    }

    @Override
    public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {

        if ((keyCode == android.view.KeyEvent.KEYCODE_BACK)) {
            onBackPressed();
            return true;
        }
        return false;
    }

//    @Override
//    protected void onRestoreInstanceState(Bundle savedInstanceState) {
//        super.onRestoreInstanceState(savedInstanceState);
//
//        this.objectFactory = savedInstanceState.getParcelable(Constants.BundleConstants.DATA_FACTORY);
//        this.redirectResponse = savedInstanceState.getParcelable(Constants.BundleConstants.KEY_REDIRECT_RESPONSE);
//        this.transactionRequest = savedInstanceState.getParcelable(Constants.BundleConstants.KEY_REQUEST);
//        this.sdkContext = savedInstanceState.getParcelable(Constants.BundleConstants.KEY_SDK_CONTEXT);
//        this.analyticsManager = this.objectFactory.<AnalyticsManager>get(AnalyticsManager.class);
//        this.apiHelper = this.objectFactory.<APIHelper>get(APIHelper.class);
//    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(Constants.BundleConstants.KEY_SDK_CONTEXT, this.sdkContext);
        outState.putParcelable(Constants.BundleConstants.DATA_FACTORY, this.objectFactory);
        outState.putParcelable(Constants.BundleConstants.KEY_REDIRECT_RESPONSE, this.redirectResponse);
        outState.putParcelable(Constants.BundleConstants.KEY_REQUEST, this.transactionRequest);
    }

    @Override
    public void onCancel(DialogInterface dialog) {

        onBackPressed();
    }

    public class ActivityImplicitIntentDialog extends Dialog {

        private RedirectResponse redirectResponse;
        private ObjectFactory objectFactory;

        public ActivityImplicitIntentDialog(@NonNull Context context, int themeResId, ObjectFactory objectFactory) {
            super(context, themeResId);
            this.objectFactory = objectFactory;
        }

        @Override
        public void show() {

            Window window = getWindow();
            window.setGravity(Gravity.BOTTOM);
            window.setLayout(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.WRAP_CONTENT);

            super.show();
        }
    }


//    private void checkStatusAndFinish(@NonNull final Intent intent) {
//
//        final APIManager apiManager = this.objectFactory.<APIManager>get(APIManager.class);
//        final boolean isInUATMode = Utils.isTrue(this.objectFactory.<Boolean>get(Constants.MerchantMeta.IS_UAT));
//        final Map<String, String> headers = this.objectFactory.getHashMap();
//        final Config config = this.objectFactory.<Config>get(Config.class);
//        final Retries retries = new Retries();
//        final ScheduledExecutorService pollingExecutor = config.getPollingExecutor();
//        pollingExecutor.scheduleAtFixedRate(new Runnable() {
//
//            @Override
//            public void run() {
//
//                String endPoint = NetworkConstants.getTransactionStatusUrl(isInUATMode) + "?t=" + System.currentTimeMillis();
//                JSONObject payload = new JSONObject();
//                try {
//                    payload.put(Constants.GenericConstants.KEY_MERCHANT_ID, objectFactory.get(Constants.MerchantMeta.MERCHANT_ID));
//                    payload.put(TIME_STAMP, System.currentTimeMillis());
//                    String base64Payload = Base64.encodeToString(payload.toString().getBytes("UTF-8"), Base64.NO_WRAP);
//                    String checksum = getCheckSum(base64Payload);
//                    headers.put(Constants.GenericConstants.SDK_CHECKSUM, checksum);
//                    APIManager.NetworkResponse networkResponse = apiManager.makePostRequest(endPoint, headers, base64Payload, false);
//
//                    int maxRetryCount = config.getStatusCheckMaxRetryCount();
//                    retries.count = retries.count + 1;
//                    if (networkResponse.isSuccess) {
//
//                        TransactionStatus transactionStatus = TransactionStatus.fromJsonString(networkResponse.response, objectFactory, TransactionStatus.class);
//
//                        SdkLogger.d(TAG, String.format("transaction status : {%s]", transactionStatus.getState()));
//                        switch (transactionStatus.getState().toLowerCase()) {
//
//                            case TransactionStatus.STATE_SUCCESS:
//                            case TransactionStatus.STATE_FAILURE:
//                            case TransactionStatus.STATE_EXPIRED:
//                            case TransactionStatus.STATE_TIMED_OUT:
//                                pollingExecutor.shutdown();
//                                setResult(transactionStatus, intent);
//                                break;
//                        }
//                    } else if(maxRetryCount < retries.count) {
//
//                        pollingExecutor.shutdown();
//                        TransactionStatus transactionStatus = objectFactory.<TransactionStatus>get(TransactionStatus.class);
//                        transactionStatus.setState(TransactionStatus.STATE_TIMED_OUT);
//                        setResult(transactionStatus, intent);
//                    }
//                } catch (Exception e) {
//                    e.printStackTrace();
//                }
//
//            }
//        }, 0L, 10000, TimeUnit.MILLISECONDS);
//    }
//
//    private String getCheckSum(String body) {
//        try {
//            String endPoint = NetworkConstants.APIEndPoints.API_TRANSACTION_STATUS;
//            String signature = this.objectFactory.getPackageSignature();
//            CryptLib cryptLib = new CryptLib();
//            byte[] hash = cryptLib.SHA256(body+endPoint+signature);
//            StringBuffer hashtext = new StringBuffer();
//
//            for (int i = 0; i < hash.length; i++) {
//                String hex = Integer.toHexString(0xff & hash[i]);
//                if (hex.length() == 1) hashtext.append('0');
//                hashtext.append(hex);
//            }
//            // Uncomment this when you want to debug Checksum logic
//            //SdkLogger.d(TAG, "Body: "+body+"\nEndPoint: "+endPoint+"\nSignature: "+signature+"\nHashText:"+hashtext);
//            return hashtext.toString();
//        } catch (Exception e) {
//            SdkLogger.e(TAG, e.getMessage(), e);
//            return null;
//        }
//    }
//
//    private void setResult(@NonNull TransactionStatus transactionStatus, Intent intent) {
//
//        intent.putExtra(Constants.GenericConstants.KEY_TRANSACTION_RESULT, transactionStatus.toJsonString());
//        setResult(RESULT_OK, intent);
//        finish();
//    }
//
//    private static final class Retries {
//
//        public int count;
//    }
}
