package com.phonepe.intent.sdk.subscriptions.network.request;

import android.support.annotation.NonNull;

import com.phonepe.intent.sdk.models.DefaultJsonImpl;

public class AuthInitRequest extends DefaultJsonImpl {

    private static final String KEY_MERCHANT_ID = "merchantId";
    private static final String KEY_SUBSCRIPTION_ID = "subscriptionId";
    private static final String KEY_MERCHANT_USER_ID = "merchantUserId";
    private static final String KEY_AUTH_REQUEST_ID = "authRequestId";
    private static final String KEY_AMOUNT = "amount";

    public void setMerchantId(@NonNull String merchantId) {
        put(KEY_MERCHANT_ID, merchantId);
    }

    public void setMerchantUserId(@NonNull String merchantUserId) {
        put(KEY_MERCHANT_USER_ID, merchantUserId);
    }

    public void setSubscriptionId(@NonNull String subscriptionId) {
        put(KEY_SUBSCRIPTION_ID, subscriptionId);
    }

    public void setAuthRequestId(String authRequestId) {
        put(KEY_AUTH_REQUEST_ID, authRequestId);
    }

    public void setAmount(@NonNull Long amount) {
        put(KEY_AMOUNT,amount);
    }

}