package com.phonepe.intent.sdk.networking.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.widget.ListView;

import com.phonepe.intent.sdk.models.AbstractJson;
import com.phonepe.intent.sdk.models.ApplicationInfo;
import com.phonepe.intent.sdk.models.DefaultJsonImpl;
import com.phonepe.intent.sdk.models.Params;
import com.phonepe.intent.sdk.utils.Constants;
import com.phonepe.intent.sdk.utils.GenericJSONUtils;
import com.phonepe.intent.sdk.utils.SdkLogger;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class RedirectResponse extends DefaultJsonImpl implements Parcelable {

    private static final String TAG = "RedirectResponse";
    private static final String KEY_CODE = "code";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_DATA = "data";
    private static final String KEY_REDIRECT_TYPE = "redirectType";
    private static final String KEY_REDIRECT_URL = "redirectURL";
    private static final String KEY_UPI_APPS = "filteredUpiApps";
    private static final String KEY_TOKEN = "token";
    private static final String KEY_CODE_SUCCESS = "SUCCESS";
    private static final String KEY_CODE_PAYMENT_INITIATED = "PAYMENT_INITIATED";

    // v4 methods

    public String getCode() {
        return this.get(KEY_CODE);
    }

    public boolean isSuccess() {
        return getCode() != null && (getCode().matches(KEY_CODE_SUCCESS) || getCode().matches(KEY_CODE_PAYMENT_INITIATED));
    }

    public String getMessage() {
        return this.get(KEY_MESSAGE);
    }

    public Constants.RedirectType getRedirectType() {
        return Constants.RedirectType.valueOf(AbstractJson.<String>get(getData(), KEY_REDIRECT_TYPE));
    }

    public String getRedirectUrl() {
        return AbstractJson.<String>get(getData(), KEY_REDIRECT_URL);
    }

    public String getToken() {
        return AbstractJson.get(getData(), KEY_TOKEN);
    }

    private JSONObject getData() {
        return this.<JSONObject>get(KEY_DATA);
    }

    public List<ApplicationInfo> getUpiApps() {

        List<ApplicationInfo> upiApps = getObjectFactory().getArrayList();
        JSONArray jsonArray = new JSONArray();
        try {
            jsonArray = AbstractJson.<JSONArray>get(getData(), KEY_UPI_APPS);
        } catch (Exception e) {
            SdkLogger.e(TAG, e.getMessage(), e);
        }
        if (jsonArray == null || jsonArray.length() == 0) {

            return upiApps;
        }

        for (int index = 0; index < jsonArray.length(); index++){

            JSONObject appInfo = AbstractJson.get(jsonArray,index);
            if(appInfo == null){
                continue;
            }

            ApplicationInfo applicationInfo = ApplicationInfo.fromJsonString(appInfo.toString(),getObjectFactory(), ApplicationInfo.class);

            if(applicationInfo == null || !applicationInfo.isEnabled()){
                continue;
            }

            upiApps.add(applicationInfo);
        }

        return upiApps;
    }

    public RedirectResponse() {
    }


    //*********************************************************************
    // Parcel related
    //*********************************************************************

    protected RedirectResponse(Parcel in) {
        super(in);
    }


    @Override
    public int describeContents() {
        return super.describeContents();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
    }

    public static final Creator<RedirectResponse> CREATOR = new Creator<RedirectResponse>() {
        @Override
        public RedirectResponse createFromParcel(Parcel source) {
            return new RedirectResponse(source);
        }

        @Override
        public RedirectResponse[] newArray(int size) {
            return new RedirectResponse[size];
        }
    };

    //*********************************************************************
    // End of class
    //*********************************************************************
}
