package com.phonepe.intent.sdk.networking.models;


import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.models.DefaultJsonImpl;

public class DeviceEventPayload extends DefaultJsonImpl {

    private static final String KEY_MERCHANTID = "merchantId";
    private static final String KEY_LOG_LEVEL = "logLevel";
    private static final String KEY_SOURCE = "source";
    private static final String KEY_TEXT = "text";

    public static final String SOURCE_ANDROID = "ANDROID";
    public static final String SOURCE_WEB = "EMBEDDED";
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String WARN = "WARN";
    public static final String ERROR = "ERROR";

    public DeviceEventPayload(ObjectFactory objectFactory, String merchantId, String logLevel, String source, String text) {
        init(objectFactory, null);
        setMerchantId(merchantId);
        setLogLevel(logLevel);
        setSource(source);
        setText(text);
    }

    public void setMerchantId(String merchantId) {
        put(KEY_MERCHANTID, merchantId);
    }

    public void setLogLevel(String logLevel) {
        put(KEY_LOG_LEVEL, logLevel);
    }

    public void setSource(String source) {
        put(KEY_SOURCE, source);
    }

    public void setText(String text) {
        put(KEY_TEXT, text);
    }

}
