package com.phonepe.intent.sdk.networking;


import android.os.Build;

import com.phonepe.intent.sdk.BuildConfig;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Sharath Pandeshwar
 * @since 17/09/16.
 * <p>
 * class to hold network related constants
 */
public class NetworkConstants {

    public static final String ENV_STAGE = "stage";
    private static final String ENV_PROD = "prod";
    public static final String KEY_X_VERIFY = "X-VERIFY";
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    public static final int CONNECTION_CONNECTION_TIMEOUT = 15000;
    public static final int CONNECTION_READ_TIMEOUT = 15000;

    public static final String KEY_CONTENT_TYPE = "Content-Type";
    public static final String KEY_CONTENT_TYPE_VALUE = "application/json";
    public static final String KEY_SOURCE_HEADER = "X-CHANNEL-ID";
    public static final String KEY_SOURCE_HEADER_VALUE = "phonepe_android_sdk";
    public static final String KEY_APP_ID = "X-APP-ID";
    public static final String KEY_MERCHANT_APP_ID = "X-MERCHANT-APP-ID";
    public static final String KEY_DEVICE_MANUFACTURER = "X-DEVICE-MANUFACTURER";
    public static final String KEY_DEVICE_MODEL = "X-DEVICE-MODEL";
    public static final String KEY_OS_VERSION = "X-OS-VERSION";
    public static final String KEY_APP_VERSION = "X-APP-VERSION";
    public static final String KEY_SOURCE_VERSION = "X-SOURCE-VERSION";

    public static final String KEY_DEVICE_ID = "X-DEVICE-ID";
    public static final String KEY_DEVICE_UPI_ID = "X-DEVICE-UPI-ID";
    public static final String KEY_NPCI_LIBRARY_VERSION = "X-NPCI-LIBRARY-VERSION";
    public static final String PHONEPE_COM = ".phonepe.com";
    public static final String JAVASCRIPT = "javascript";
    public static final int MAX_IDLE_CONNECTIONS = 2;
    public static final long MAX_KEEP_ALIVE = 60;
    public static final String TOKEN_STATUS_PATH = "/apis/v1/sdk/status/";
    public static final String KEY_AUTH_TOKEN = "x-auth-token";

    /**
     * The API version in use by the app
     */
    private static final int API_VERSION = 3;

    public static final String LOCAL_HOST = "172.17.61.0:8080";
    public static final String STAGE_HOST = "mercury-stg.phonepe.com";
    private static final String UAT_HOST = "mercury-uat.phonepe.com";
    private static final String TX_HOST = "mercury-tx.phonepe.com";
    public static final String PRODUCTION_HOST_T1 = "mercury-t1.phonepe.com";
    public static final String PRODUCTION_HOST = "mercury-t2.phonepe.com";

    public static final Set<String> validCertificates = new HashSet<>(Arrays.asList(Certificate.CA_CERT_HASH, Certificate.CA_CERT_HASH1, Certificate.CA_CERT_HASH2, Certificate.CA_CERT_HASH3));
    public static String WEB_URL;
    public static String BACKEND_URL;

    public static String getBaseHost(boolean isInUATMode) {

        return getServer(isInUATMode).basePort;
    }

    public static String getTransactionStatusUrl(boolean isInUatMode){

        return getApiBaseUrl(isInUatMode)+APIEndPoints.API_TRANSACTION_STATUS;
    }

    /**
     * Enum to switch between servers
     */
    private enum Server {

        LOCAL(HTTP, LOCAL_HOST, API_VERSION),

        STAGE(HTTPS, STAGE_HOST, API_VERSION),

        UAT(HTTPS, UAT_HOST, API_VERSION),

        TX(HTTPS, TX_HOST, API_VERSION),

        PRODUCTION_T1(HTTPS, PRODUCTION_HOST_T1, API_VERSION),

        PRODUCTION(HTTPS, PRODUCTION_HOST, API_VERSION);


        public final String scheme;
        public final String baseUrl;
        public final String basePort;
        public final String baseUrlWithApiVersion;


        Server(String scheme, final String url, final int apiVersion) {
            this.scheme = scheme;
            baseUrlWithApiVersion = this.scheme + url + "/v" + apiVersion + "/";
            baseUrl = this.scheme + url;
            basePort = url;
        }

        public String getBasePort() {
            return basePort;
        }
    }

    // private static Server SERVER = Build.VERSION.SDK_INT > 19 ? Server.PRODUCTION : Server.PRODUCTION_T1;
    //  public static String BASE_HOST = SERVER.basePort;

    public static Server getServer(boolean isInUATMode) {
        if (isInUATMode) {
            if (BuildConfig.BUILD_TYPE.matches(ENV_STAGE)) {
                return Server.STAGE;
            } else {
                return Server.UAT;
            }
        } else {
            return Build.VERSION.SDK_INT > 19 ? Server.PRODUCTION : Server.PRODUCTION_T1;
        }
    }

    public static String getApiBaseUrlWithVersion(boolean isInUATMode) {
        if (BuildConfig.BUILD_TYPE.matches(ENV_PROD)) {
            return getServer(isInUATMode).baseUrlWithApiVersion;
        } else {
            if (BACKEND_URL != null && !BACKEND_URL.isEmpty()) {
                return BACKEND_URL + "/v" + API_VERSION + "/";
            } else {
                return getServer(isInUATMode).baseUrlWithApiVersion;
            }
        }
    }

    public static String getApiBaseUrl(boolean isInUATMode) {
        if (BuildConfig.BUILD_TYPE.matches(ENV_PROD)) {
            return getServer(isInUATMode).baseUrl;
        } else {
            if (BACKEND_URL != null && !BACKEND_URL.isEmpty()) {
                return BACKEND_URL;
            } else {
                return getServer(isInUATMode).baseUrl;
            }
        }
    }

    public static String getApiBaseWebUrl(boolean isInUATMode) {
        if (BuildConfig.BUILD_TYPE.matches(ENV_PROD)) {
            return getServer(isInUATMode).baseUrl;
        } else {
            if (WEB_URL != null && !WEB_URL.isEmpty()) {
                return WEB_URL;
            } else {
                return getServer(isInUATMode).baseUrl;
            }
        }
    }

    public static String getAssetStatsUrl(boolean isInUATMode) {
        return getServer(isInUATMode).baseUrl + APIEndPoints.API_ASSET_STATS;
    }

    public static String getDeviceLogUrl(boolean isInUATMode) {
        return getServer(isInUATMode).baseUrl + APIEndPoints.API_DEVICE_LOGS;
    }

    public interface APIEndPoints {
        String API_EVENT_INJESTION = "/apis/v2/sdk/event";
        String API_ASSET_STATS = "/app/asset-stats";
        String API_DEVICE_LOGS = "/v1/sdk/log";
        String API_TRANSACTION_STATUS = "/apis/v1/transaction/status";
        String API_WALLET_BALANCE = "/v3/wallet/balance";
        String API_WALLET_TOPUP = "/v3/wallet/topup";
        String API_AVAILABILITY_CHECK = "/v3/availabilitycheck";
        String API_SDK_CONFIG = "/apis/v2/sdk/config";

        String API_SUBSCRIPTION_CREATE = "/v3/recurring/subscription/create";
        String API_SUBSCRIPTION_AUTH_INIT = "/v3/recurring/auth/init";
        String API_SUBSCRIPTION_DEBIT_INIT = "/v3/recurring/debit/init";
    }

    public static final class Certificate {
        public static final String CA_CERT_HASH = "47DEQpj8HBSa+/TImW+5JCeuQeRkm5NMpJWZG3hSuFU=";
        public static final String CA_CERT_HASH1 = "9Bwm9kIBsrAcvjMPTDjBzKtSD8OnnsGZPwlTJDMKteA=";
        public static final String CA_CERT_HASH2 = "8Rw90Ej3Ttt8RRkrg+WYDS9n7IS03bk5bjP/UXPtaY8=";
        public static final String CA_CERT_HASH3 = "Ko8tivDrEjiY90yGasP6ZpBU4jwXvHqVvQI0GS3GNdA=";
    }

    //*********************************************************************
    // End of class
    //*********************************************************************

}
