package com.phonepe.intent.sdk.mvp;

import android.content.Context;
import android.net.Uri;

/**
 * @author TheEternalWitness
 * @since 31/03/18.
 */
public interface iTransactionView {

    Context getContext();

    void setLoadingStatus(boolean status);

    void showError(String error, boolean showRetry);

    void openUrlInWebView(String url);

    void openActivityForResult(Uri url);

    /**
     * View must be able to announce the result
     *
     * @param result
     */
    void endWithResult(String result);

    /**
     * View must be able to able to cancel itself
     */
    void endWithCancel(String result);

    /**
     * Interface contract to class which establishes bridge to Javascript
     *
     * @param callback Javascript callback name
     * @param error    Error body if any
     * @param response
     * @param context
     * @param body
     */
    void onBridgeCallBack(String callback, String error, String response, String context, String body);

    /**
     * Alert to get confirmation on back button click
     */
    void showAlert();
}
