package com.phonepe.intent.sdk.models;

import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.utils.GenericJSONUtils;
import com.phonepe.intent.sdk.utils.SdkLogger;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Date 19/07/17
 *
 * @author Ankit Jain
 */
public class UrlConfigData {

    public static final String TAG = "UrlConfigData";
    private static final String KEY_URL_CONFIG = "urlConfig";
    public UrlConfig urlConfig;

    public UrlConfig getUrlConfig() {
        return urlConfig;
    }

    public static UrlConfigData fromJson(String res, ObjectFactory objectFactory) {
        UrlConfigData urlConfigData = new UrlConfigData();
        try {
            JSONObject jsonObject = new JSONObject(res);
            JSONObject urlConfigJsonObject = GenericJSONUtils.readJSONObject(jsonObject, KEY_URL_CONFIG, true, true);
            if (urlConfigJsonObject != null) {
                urlConfigData.urlConfig = UrlConfig.fromJson(urlConfigJsonObject.toString(), objectFactory);
            }
        } catch (JSONException e) {
            SdkLogger.e(TAG, String.format("JSONException caught with message = {%s}", e.getMessage()), e);
        }

        return urlConfigData;
    }
}
