package com.phonepe.intent.sdk.models;

import android.support.annotation.NonNull;

public class TransactionStatus extends DefaultJsonImpl {

    public static final String TAG = "TransactionStatus";
    private static String KEY_STATE = "state";
    private static String KEY_PROVIDER_REFERENCE_ID = "providerReferenceId";
    public static String STATE_CREATED = "created";
    public static final String STATE_SUCCESS = "success";
    public static final String STATE_FAILURE = "failed";
    public static final String STATE_TIMED_OUT = "timed_out";
    public static final String STATE_EXPIRED = "expired";
    public static final String STATE_USER_CANCEL = "user_cancel";

    public void setState(@NonNull String state) {

        this.<String>put(KEY_STATE, state);
    }

    public void setProviderReferenceId(@NonNull String providerReferenceId){

        this.<String>put(KEY_PROVIDER_REFERENCE_ID, providerReferenceId);
    }

    public String getState() {

        return this.<String>get(KEY_STATE);
    }

    public String getProviderReferenceId() {

        return this.<String>get(KEY_PROVIDER_REFERENCE_ID);
    }

}
