package com.phonepe.intent.sdk.models;

/**
 * @author TheEternalWitness
 * @since 31/03/18.
 */
public class SimInfo {
    private final int mCC;
    private final int mNC;
    public int subscriptionId;
    public String carrier;
    public String number;
    private int slotIndex;
    private int mobileNetworkCode;

    public SimInfo(int subscriptionId, String carrier, String number, int index, int mCC, int mNC) {
        this.subscriptionId = subscriptionId;
        this.carrier = toCamelCase(carrier);
        this.number = number;
        this.slotIndex = index;
        this.mCC = mCC;
        this.mNC = mNC;
    }

    public static String toCamelCase(final String init) {
        if (init == null) return null;

        final StringBuilder ret = new StringBuilder(init.length());

        for (final String word : init.split(" ")) {
            if (!word.isEmpty()) {
                ret.append(word.substring(0, 1).toUpperCase());
                ret.append(word.substring(1).toLowerCase());
            }
            if (!(ret.length() == init.length())) ret.append(" ");
        }

        return ret.toString();
    }
}
