package com.phonepe.intent.sdk.models;


import com.phonepe.intent.sdk.utils.Utils;

import org.json.JSONArray;

import java.util.List;

/**
 * @author Suman PPE
 * @since 09/06/17.
 */
public class PermissionsBody extends DefaultJsonImpl {

    private static final String TAG = "PermissionsBody";
    private static final String KEY_PERMISSIONS = "permission";

    public void addPermission(PermissionsObject permissionsObject) {

        JSONArray jsonArray = this.<JSONArray>get(KEY_PERMISSIONS);
        jsonArray = jsonArray != null ? jsonArray : new JSONArray();
        jsonArray.put(permissionsObject.getJsonObject());
        put(KEY_PERMISSIONS, jsonArray);
    }

    public void setPermissions(List<PermissionsObject> permissions) {

        if (Utils.isNull(permissions, PermissionsBody.TAG, "permissions")
                || Utils.isNull(getJsonObject(), PermissionsBody.TAG, "jsonObject")) {

            return;
        }

        JSONArray jsonArray = new JSONArray();
        for (PermissionsObject permissionsObject : permissions) {

            jsonArray.put(permissionsObject.getJsonObject());
        }

        put(KEY_PERMISSIONS, jsonArray);

    }
}
