package com.phonepe.intent.sdk.models;

import com.phonepe.intent.sdk.utils.Constants;
import com.phonepe.intent.sdk.utils.GenericJSONUtils;
import com.phonepe.intent.sdk.utils.SdkLogger;

import org.json.JSONArray;
import org.json.JSONException;

import java.util.List;

/**
 * @author Suman PPE
 * @since 09/06/17.
 */
public class PermissionData extends DefaultJsonImpl {

    private static final String KEY_PERMMISSIONS = "permissions";
    private static final String TAG = "PermissionData";

    public List<String> getPermissions() {

        List<String> permissions = getObjectFactory().<String>getArrayList();
        JSONArray jsonArray = null;
        try {
            jsonArray = GenericJSONUtils.readJSONArray(getJsonObject(), KEY_PERMMISSIONS, false, false);
            for (int i = 0; i < jsonArray.length(); i++) {
                permissions.add(jsonArray.get(i).toString());
            }
        } catch (JSONException e) {

            SdkLogger.e(TAG, String.format(Constants.LogFormats.JSON_EXCEPTION, e.getMessage(), "permission"));
        }

        return permissions;
    }

    public List<String> getPermission() {

        List<String> permissions = getObjectFactory().<String>getArrayList();
        JSONArray jsonArray = null;
        try {
            jsonArray = GenericJSONUtils.readJSONArray(getJsonObject(), KEY_PERMMISSIONS, false, false);
            for (int i = 0; i < jsonArray.length(); i++) {
                permissions.add("android.permission."+jsonArray.get(i).toString());
            }
        } catch (JSONException e) {

            SdkLogger.e(TAG, String.format(Constants.LogFormats.JSON_EXCEPTION, e.getMessage(), "permission"));
        }

        return permissions;
    }
}
