package com.phonepe.intent.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.phonepe.intent.sdk.utils.GenericJSONUtils;
import com.phonepe.intent.sdk.utils.SdkLogger;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Date 05/06/17
 *
 * @author Ankit Jain
 */

public class Params extends DefaultJsonImpl implements Parcelable {

    public static final String TAG = "Params";
    private static final String KEY_KEY = "key";
    private static final String KEY_VALUE = "value";

    public Params() {
    }

    public void setKey(String key) {
       this.<String>put(KEY_KEY,key);
    }

    public void setValue(String value) {
        this.<String>put(KEY_VALUE,value);
    }

    public String getKey() {

        return this.<String>get(KEY_KEY);
    }

    public String getValue() {
        return this.<String>get(KEY_VALUE);
    }

    public String getAsUrlParameter(){

        return String.format("%s=%s",getKey(),getValue());
    }



    //*********************************************************************
    // Parcel related
    //*********************************************************************

    @Override
    public int describeContents() {
        return super.describeContents();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
      super.writeToParcel(dest,flags);
    }

    protected Params(Parcel in) {
       super(in);
    }


    public static final Creator<Params> CREATOR = new Creator<Params>() {
        @Override
        public Params createFromParcel(Parcel source) {
            return new Params(source);
        }

        @Override
        public Params[] newArray(int size) {
            return new Params[size];
        }
    };


    //*********************************************************************
    // End of class
    //*********************************************************************
}
