package com.phonepe.intent.sdk.models;

/**
 * @author TheEternalWitness
 * @since 17/04/18.
 */
public enum NetworkType {
    //@SerializedName("WIFI")
    WIFI("WIFI"),

    //@SerializedName("MOBILE_DATA")
    MOBILE_DATA("MOBILE_DATA"),

    //@SerializedName("MOBILE_DATA_2G")
    MOBILE_DATA_2G("MOBILE_DATA_2G"),

    //@SerializedName("MOBILE_DATA_3G")
    MOBILE_DATA_3G("MOBILE_DATA_3G"),

    //@SerializedName("MOBILE_DATA_4G")
    MOBILE_DATA_4G("MOBILE_DATA_4G"),

    //@SerializedName("MOBILE_DATA_UNKNOWN")
    MOBILE_DATA_UNKNOWN("MOBILE_DATA_UNKNOWN"),

    //@SerializedName("NO_NETWORK")
    NO_NETWORK("NO_NETWORK");

    private String value;

    NetworkType(String value) {
        this.value = value;
    }

    public static NetworkType from(String networkTypeValue) {
        for (NetworkType networkType : NetworkType.values()) {
            if (networkType.getValue().equals(networkTypeValue)) return networkType;
        }
        return null;
    }

    public String getValue() {
        return value;
    }
}