package com.phonepe.intent.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;


/**
 * @author Prasad Pai
 * @since 16/03/16
 * <p>
 * Model for Location
 */
@SuppressWarnings("unused")
public class MyLocation extends DefaultJsonImpl implements Parcelable {

    public static final String TAG = "MyLocation";
    private static final String KEY_LAT = "latitude";
    private static final String KEY_LNG = "longitude";

    public static final Creator<MyLocation> CREATOR = new Creator<MyLocation>() {
        @Override
        public MyLocation createFromParcel(Parcel source) {
            return new MyLocation(source);
        }

        @Override
        public MyLocation[] newArray(int size) {
            return new MyLocation[size];
        }
    };
    private double latitude;
    private double longitude;

    protected MyLocation(Parcel in) {

        super(in);
        this.latitude = in.readDouble();
        this.longitude = in.readDouble();
    }

    public MyLocation() {
    }

    public boolean isZeroLocation() {

        return latitude == 0 && longitude == 0;
    }

    public void setLatitude(double latitude) {

        this.latitude = latitude;
        this.<Double>put(KEY_LAT, latitude);
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
        this.<Double>put(KEY_LNG, longitude);
    }

    public double getLatitude() {
        return latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    @Override
    public int describeContents() {
        return super.describeContents();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeDouble(this.latitude);
        dest.writeDouble(this.longitude);
    }
}

