package com.phonepe.intent.sdk.models;

import com.phonepe.intent.sdk.utils.GenericJSONUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Prasad Pai
 * @since 02/05/18.
 */

public class JusPayData {

    private static final String KEY_USE_JUSPAY = "useJusPay";
    private static final String KEY_ORDER_ID = "orderId";
    private static final String KEY_AMOUNT = "amount";
    private static final String KEY_JUSTPAY_MERCHANT_ID = "jusPayMerchantId";
    private static final String KEY_JUSTPAY_CLIENT_ID = "jusPayClientId";
    private static final String KEY_TRANSACTION_ID = "transactionId";
    public static final String KEY_REDIRECT_URL = "redirectURL";
    private static final String KEY_END_URLS = "endUrls";


    private boolean useJusPay;
    private String justPayMerchantId;
    private String justPayClientId;
    private String transactionId;
    private String orderId;
    private float amount;
    private String redirectURL;
    private String[] endUrls;

    public String getJustPayMerchantId() {
        return justPayMerchantId;
    }

    public String getJustPayClientId() {
        return justPayClientId;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public String getRedirectURL() {
        return redirectURL;
    }

    public String getAmount() {
        return String.valueOf(amount / 100f);
    }

    public String[] getEndUrls() {
        return endUrls;
    }

    public static JusPayData fromJson(String res) throws JSONException {
        JusPayData justPayData = new JusPayData();
        String[] endUrl;

        JSONObject jsonObject = new JSONObject(res);
        justPayData.useJusPay = GenericJSONUtils.readBoolean(jsonObject, KEY_USE_JUSPAY, true, true);
        justPayData.justPayMerchantId = GenericJSONUtils.readString(jsonObject, KEY_JUSTPAY_MERCHANT_ID, true, true);
        justPayData.justPayClientId = GenericJSONUtils.readString(jsonObject, KEY_JUSTPAY_CLIENT_ID, true, true);
        justPayData.transactionId = GenericJSONUtils.readString(jsonObject, KEY_TRANSACTION_ID, true, true);
        justPayData.redirectURL = GenericJSONUtils.readString(jsonObject, KEY_REDIRECT_URL, true, true);
        justPayData.orderId = GenericJSONUtils.readString(jsonObject, KEY_ORDER_ID, true, true);
        justPayData.amount = GenericJSONUtils.readFloat(jsonObject, KEY_AMOUNT, true, true);

        JSONArray jsonArray = GenericJSONUtils.readJSONArray(jsonObject, KEY_END_URLS, false, false);
        endUrl = new String[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); i++) {
            endUrl[i] = (jsonArray.get(i).toString());
        }
        justPayData.endUrls = endUrl;

        return justPayData;
    }
}
