package com.phonepe.intent.sdk.models;


import com.phonepe.intent.sdk.core.DataConfig;
import com.phonepe.intent.sdk.core.ObjectFactory;
import com.phonepe.intent.sdk.core.ObjectFactoryInitializationStrategy;
import com.phonepe.intent.sdk.utils.Constants;
import com.phonepe.intent.sdk.utils.GenericJSONUtils;
import com.phonepe.intent.sdk.utils.SdkLogger;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class IntentSDKConfig implements ObjectFactoryInitializationStrategy {

    private static final String TAG = "IntentSDKConfig";

    private static final String KEY_SDK_STARTUP_CONFIG = "sdkStartupConfig";
    private static final String KEY_AVAILABILITY_CHECK = "availabilityCheck";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_TIMEOUT_MS = "timeoutMs";

    private static final String KEY_AVAILABILITY_CHECK_ENABLED = "availability_check_enabled";
    private static final String KEY_AVAILABILITY_CHECK_TIMEOUT_MS = "availability_check_timeout_ms";

    private DataConfig dataConfig;
    private ObjectFactory objectFactory;


    @Override
    public void init(ObjectFactory objectFactory, ObjectFactory.InitializationBundle initializationBundle) {
        this.objectFactory = objectFactory;
        dataConfig = objectFactory.get(DataConfig.class);
    }

    @Override
    public boolean isCachingAllowed() {
        return true;
    }

    public void updateConfig(JSONObject data) {
        if (data != null) {
            try {
                if (data.has(KEY_SDK_STARTUP_CONFIG)) {
                    JSONObject config = data.getJSONObject(KEY_SDK_STARTUP_CONFIG);
                    if (config.has(KEY_AVAILABILITY_CHECK)) {
                        JSONObject availabilityCheckConfig = config.getJSONObject(KEY_AVAILABILITY_CHECK);
                        if (availabilityCheckConfig.has(KEY_ENABLED))
                            setAvailabilityCheckEnabled(availabilityCheckConfig.getBoolean(KEY_ENABLED));

                        if (availabilityCheckConfig.has(KEY_TIMEOUT_MS))
                            setAvailabilityCheckTimeoutMs(availabilityCheckConfig.getLong(KEY_TIMEOUT_MS));
                    }
                    objectFactory.cache(Constants.GenericConstants.CONFIG_SYNCED, true);
                }
            } catch (Exception e) {
                // todo: add event
                SdkLogger.e(TAG, e.getMessage(), e);
            }
        }
    }

    public boolean isAvailabilityCheckEnabled() {
        return dataConfig.getBool(KEY_ENABLED, true);
    }

    public void setAvailabilityCheckEnabled(boolean enabled) {
        dataConfig.saveBool(KEY_AVAILABILITY_CHECK_ENABLED, enabled);
    }

    public Long getAvailabilityCheckTimeoutMs() {
        return dataConfig.getLong(KEY_AVAILABILITY_CHECK_TIMEOUT_MS, 1000L);
    }

    public void setAvailabilityCheckTimeoutMs(Long timeoutMs) {
        dataConfig.saveLong(KEY_AVAILABILITY_CHECK_TIMEOUT_MS, timeoutMs);
    }
}
