package com.phonepe.intent.sdk.models;

import android.content.Intent;
import android.os.Bundle;

import com.phonepe.intent.sdk.utils.SdkLogger;

/**
 * @author TheEternalWitness
 * @since 13/04/18.
 */
public class IntentResponse {
    private static final String TAG = "IntentResponse";
    static final String KEY_UPI_RESPONSE = "response";
    static final String KEY_STATUS = "Status";
    static final String KEY_TXN_REF = "txnRef";
    static final String KEY_TXN_ID = "txnId";
    static final String KEY_RESPONSE_CODE = "responseCode";

    private String response;
    private String status;
    private String txnRef;
    private String txnId;
    private String responseCode;

    @Override
    public String toString() {
        return "response:" + response + " :: status:" + status + " :: txnRef: " + txnRef + " :: txnId" + txnId + " :: responseCode" + responseCode;
    }

    /**
     * Helper method to analyse PhonePe's payment result
     *
     * @param intent
     * @return
     */
    public static IntentResponse getResult(Intent intent) {
        if (intent == null || intent.getExtras() == null) {
            SdkLogger.e(TAG, "intent is null or empty");
            return null;
        }

        IntentResponse paymentResponse = new IntentResponse();
        Bundle bundle = intent.getExtras();

        paymentResponse.response = bundle.getString(IntentResponse.KEY_UPI_RESPONSE);
        paymentResponse.status = bundle.getString(IntentResponse.KEY_STATUS);
        paymentResponse.responseCode = bundle.getString(IntentResponse.KEY_RESPONSE_CODE);
        paymentResponse.txnId = bundle.getString(IntentResponse.KEY_TXN_ID);
        paymentResponse.txnRef = bundle.getString(IntentResponse.KEY_TXN_REF);

        SdkLogger.d(TAG, String.format("IntentResponse = {%s}", paymentResponse.toString()));
        return paymentResponse;
    }


}
