package com.phonepe.intent.sdk.models;

import android.content.Intent;
import android.support.annotation.NonNull;

import com.phonepe.intent.sdk.bridges.DataStore;
import com.phonepe.intent.sdk.core.BaseConfig;
import com.phonepe.intent.sdk.core.DataConfig;
import com.phonepe.intent.sdk.core.ObjectFactory;

public class ApplicationInfo extends DefaultJsonImpl {
    private static final String KEY_NAME = "appName";
    private static final String KEY_PACKAGE_NAME = "packageName";
    private static final String KEY_VERSION = "appVersionCode";
    private static final String KEY_LAST_USED = "lastUsed";
    private static final String KEY_ENABLED = "enabled";
    private static final String LAST_USED_UPI_APP = "f2aa8191-1945-4b84-a511-6bdae6556280";

    public void setName(String name) {
        put(KEY_NAME, name);
    }

    public void setPackageName(String packageName) {
        put(KEY_PACKAGE_NAME, packageName);
        BaseConfig baseConfig = getObjectFactory().<DataConfig>get(DataConfig.class);
        String lastUsedPackageName = baseConfig.getString(LAST_USED_UPI_APP, "");
        put(KEY_LAST_USED, lastUsedPackageName.equals(packageName));
    }

    public boolean isLastTimeUsed() {

        BaseConfig baseConfig = getObjectFactory().<DataConfig>get(DataConfig.class);
        String lastUsedPackageName = baseConfig.getString(LAST_USED_UPI_APP, "");
        return lastUsedPackageName.equals(getPackageName());
    }

    public void markAtLastUsed() {

        BaseConfig baseConfig = getObjectFactory().<DataConfig>get(DataConfig.class);
        baseConfig.saveString(LAST_USED_UPI_APP, getPackageName());
    }

    public void setVersion(int version) {
        put(KEY_VERSION, version);
    }

    public void setActivity(@NonNull String activity) {

        BaseConfig baseConfig = getObjectFactory().<DataConfig>get(DataConfig.class);
        baseConfig.saveString(getPackageName(),activity);
    }

    public String getActivity(){

        BaseConfig baseConfig = getObjectFactory().<DataConfig>get(DataConfig.class);
        return baseConfig.getString(getPackageName(),null);
    }

    public String getAppName() {

        return this.<String>get(KEY_NAME);
    }

    public boolean isEnabled() {

        Boolean isEnabled = this.<Boolean>get(KEY_ENABLED);
        return isEnabled == null ? true : isEnabled;
    }

    public String getPackageName() {

        return this.<String>get(KEY_PACKAGE_NAME);
    }

    public int getVersion() {
        return this.<Integer>get(KEY_VERSION);
    }

    public Intent getIntent() {

        Intent intent = new Intent();

        intent.setClassName(getPackageName(), getActivity());
        return intent;
    }
}
